/*
 * SOURCE FILE : MutantObject.h
 *
 * Represents a mutated human.
 *
 */

#ifndef MutantObjectIncluded
  
  #define MutantObjectIncluded

  #include "EnemyObject.h"
  #include "SpriteImageId.h"
  #include "FrameCounter.h"
  #include "Direction4.h"
  #include "HumanObject.h"
  
  class MutantObject : public EnemyObject {
    
  public :

        // Number for sprite image used.
        UInt8 SpriteImage;
        
    /***************/
    /* CONSTRUCTOR */
    /***************/
    MutantObject() :
            SpriteImage( MutantWomanImage ),
            direction( UpDir4 )
        {
    }

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~MutantObject() {
    }
    
        /*****************************/
        /* GET TYPE OF ENEMY THIS IS */
        /*****************************/
        // Returns enemy type.
        virtual EnemyType GetEnemyType( void ) {
            return Grunt;
        }

    /*******************************************************/
    /* GET NUMBER OF POINTS AWARDED FOR KILLING THIS ENEMY */
    /*******************************************************/
    // Returns number of points.
    virtual UInt8 GetPoints( void ) {
      return 0x5;  // In BCD!
    }

        /**********************/
        /* START OFF A MUTANT */
        /**********************/
        // Pass pointer to human mutant will replace in human.
        // Pass pointer to object it will chase in player.
        void Start( HumanObject *human, GameObject *player );
        
    /************************/
    /* MOVE THE GAME OBJECT */
    /************************/
    virtual void ProtectedMove( void );

    /************************/
    /* DRAW THE GAME OBJECT */
    /************************/
    // This is only called after it has been established that the
    // game object is visible.
    virtual void Draw( Gameduino *gd ) {
      Gameduino::Rotation transform = ( FrameCounter & 8 ) ? Gameduino::FlipX : Gameduino::None;
      gd->sprite( SpriteNumber, ToPixel( Xco ), ToPixel( Yco ), SpriteImage, 0, transform, BadGuy );
    }
   
  private :
  
    // Speed at which mutants move.
    static Int16 mutantSpeed;
    
        // Direction mutant is moving.
        Direction4 direction;
        
  };
    
#endif

/* END of MutantObject.h */

