/*
 * SOURCE FILE : LevelNormal.h
 *
 * Definition of class LevelNormal.
 * Base class for all "normal" levels.
 * i.e. Levels that are not special attract modes
 * but have enemies who are trying to kill you
 * and so on.
 *
 */

#ifndef LevelNormalDefined

  #define LevelNormalDefined

  #include "Level.h"
  #include "LevelData.h"
  #include "LevelDescriptor.h"
  #include "ExplosionManager.h"
  
  class LevelNormal : public Level {

  public :

    /***************/
    /* CONSTRUCTOR */
    /***************/
    // Pass pointer to level descriptor data in data parameter.
    LevelNormal( const LevelDescriptor *data );

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~LevelNormal();

    /**************/
    /* PLAY LEVEL */
    /**************/
    // Returns code indicating how level ended.
    virtual LevelExitCode Play( void );

  protected :

    /*************/
    /* PLAY LOOP */
    /*************/
    // Returns code indicating how level ended.
    // This method should be called from the Play method after the
    // level data has been initialised and the return value returned
    // by the Play method.
    virtual LevelExitCode PlayLoop( void );
    
  private :

    // Data defining the level.
    LevelData dataForLevel;
    
    // Descriptor array of bytes.
    const LevelDescriptor *descriptorData;
    
    // Current instance being processed.
    static LevelNormal *currentInstance;

    /********************/
    /* INITIALISE LEVEL */
    /********************/
    // Pass pointer to Gameduino to draw on in gd.
    void InitialiseLevel( Gameduino *gd );

    /**********************************/
    /* DRAW SCORE AND NUMBER OF LIVES */
    /**********************************/
    void DrawScoreAndLives( void );

    /******************/
    /* DRAW THE LEVEL */
    /******************/
    void DrawLevel( void );

    /************************************************/
    /* HANDLE COLLISIONS BETWEEN HUMANS AND ENEMIES */
    /************************************************/
    // Pass index of human in level's humans array in humanIndex.
    // Pass sprite number of sprite that it hit in spriteNumber.
    static void HandleHumanCollision( UInt8 humanIndex, UInt8 spriteNumber );

    /********************************************************/
    /* HANDLE COLLISIONS BETWEEN PLAYER BULLETS AND ENEMIES */
    /********************************************************/
    // Pass index of bullet in player's bullet array in bulletIndex.
    // Pass sprite number of sprite that it hit in spriteNumber.
    static void HandleBulletCollision( UInt8 bulletIndex, UInt8 spriteNumber );

    /*********************************************************/
    /* CHECK FOR COLLISIONS BETWEEN PLAYER AND OTHER OBJECTS */
    /*********************************************************/
    // Pass pointer to a flag that will be set true if player is dead in isDead parameter.
    void CheckPlayerCollisions( bool *isDead );

    /***********************************************************************************/
    /* WAIT UNTIL SLOT FREE FOR A NEW SOUND, PLAY IT AND WAIT FOR ALL SOUNDS TO FINISH */
    /***********************************************************************************/
    // Pass sound to play in soundToPlay parameter.
    void PlaySoundAndWait( const UInt8 *soundToPlay );

  };

#endif

/* END of LevelNormal.h */

