/*
 * SOURCE FILE : LevelDescriptor.h
 *
 * Definition of class LevelDescriptor.
 * Describes a level.
 *
 */

#ifndef LevelDescriptorDefined

  #define LevelDescriptorDefined

  #include "Types.h"
  #include "EnemyType.h"

  class LevelDescriptor {

  public :

    // Number of humans.
    UInt8 HumanCount;
    
    // Array containing enemy data.
    // The array alternates between enemy type and count and MUST
    // be terminated with a byte of value ENDDESCRIPTOR.
    const UInt8* EnemyData;
    
    /***************/
    /* CONSTRUCTOR */
    /***************/
    // Pass number of humans on level in hc.
    // Pass array of data defining enemies in ed.
    // The array alternates between enemy type and count and MUST
    // be terminated with a byte of value ENDDESCRIPTOR.
    LevelDescriptor( UInt8 hc, const UInt8 *ed ) {
        HumanCount = hc;
        EnemyData = ed;
    }
    
    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~LevelDescriptor() {
    }
    
    // Used to mark the end of the descriptor array.
    #define ENDDESCRIPTOR ((UInt8)0xFF)
    
    /*****************************************/
    /* GET COUNT FOR A PARTICULAR ENEMY TYPE */
    /*****************************************/
    // Pass type of enemy to fetch count for in et.
    // Returns number of enemies of the given type on this level.
    UInt8 GetEnemyCount( EnemyType et ) const;
    
  private :

  };

#endif

/* END of LevelDescriptor.h */


