/*
 * SOURCE FILE : LevelDescriptor.cpp
 *
 * Definition of class LevelDescriptor.
 * Describes a level.
 *
 */

#include "LevelDescriptor.h"

/*****************************************/
/* GET COUNT FOR A PARTICULAR ENEMY TYPE */
/*****************************************/
// Pass type of enemy to fetch count for in et.
// Returns number of enemies of the given type on this level.
UInt8 LevelDescriptor::GetEnemyCount( EnemyType et ) const {
    bool found = false;
    const UInt8 *data = EnemyData;
    while( ! found && ( *data != ENDDESCRIPTOR ) ) {
        if( *data == (UInt8)et ) {
            found = true;
        }
        else {
            data += 2;
        }
    }        
    if( found ) {
        return data[ 1 ];
    }
    else {
        return 0;
    }
}

