/*
 * SOURCE FILE : GruntObject.h
 *
 * Represents the grunt enemy object.
 *
 */

#ifndef GruntObjectIncluded
  
  #define GruntObjectIncluded

  #include "EnemyObject.h"
  #include "SpriteImageId.h"
  #include "FrameCounter.h"
  
  class GruntObject : public EnemyObject {
    
  public :

    /***************/
    /* CONSTRUCTOR */
    /***************/
    GruntObject() {
    }

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~GruntObject() {
    }
    
        /*****************************/
        /* GET TYPE OF ENEMY THIS IS */
        /*****************************/
        // Returns enemy type.
        virtual EnemyType GetEnemyType( void ) {
            return Grunt;
        }

    /*******************************************************/
    /* GET NUMBER OF POINTS AWARDED FOR KILLING THIS ENEMY */
    /*******************************************************/
    // Returns number of points.
    virtual UInt8 GetPoints( void ) {
      return 0x5;  // In BCD!
    }

    /************************/
    /* MOVE THE GAME OBJECT */
    /************************/
    virtual void ProtectedMove( void );

    /************************/
    /* DRAW THE GAME OBJECT */
    /************************/
    // Pass Gameduino to draw on in gd.
    // This is only called after it has been established that the
    // game object is visible.
    virtual void Draw( Gameduino *gd ) {
      Gameduino::Rotation transform = ( FrameCounter & 8 ) ? Gameduino::FlipX : Gameduino::None;
      gd->sprite( SpriteNumber, ToPixel( Xco ), ToPixel( Yco ), GruntImage, 0, transform, BadGuy );
    }
   
  private :
  
    // Speed at which grunts move.
    static Int16 gruntSpeed;
    
  };
    
#endif

/* END of GruntObject.h */

