/*
 * SOURCE FILE : ExplosionManager.cpp
 *
 * Responsible for managing a collection of explosions.
 *
 */

#include "ExplosionManager.h"
#include "SpriteNumber.h"

// An instance of this class.
ExplosionManager ExplosionManager::Instance( FirstExplosionSprite );

/***************/
/* CONSTRUCTOR */
/***************/
// Pass index of first sprite used for explosions in fsn.
ExplosionManager::ExplosionManager( UInt8 fsn ) :
    firstSpriteNumber( fsn )
{
  KillAllExplosions();
}
    
/**************/
/* DESTRUCTOR */
/**************/
ExplosionManager::~ExplosionManager() {
}

/**************************/
/* START AN EXPLOSION OFF */
/**************************/
// Pass start coordinates in x and y (NOT pixel coordinates).
// Returns pointer to an ExplosionObject if it was started successfully or NULL if
// no more explosions are available at the moment.
ExplosionObject *ExplosionManager::StartExplosion( Int16 x, Int16 y ) {
  // Find a free explosion slot.
  UInt8 i = 0;
  ExplosionObject *explosion = (ExplosionObject*)NULL;
  while( ( i < MaxExplosions ) && ( explosion == (ExplosionObject*)NULL ) ) {
    if( explosionPointers[ i ] == (GameObject*)NULL ) {
      explosion = explosions + i;
      explosionPointers[ i ] = explosion;
      explosion->SpriteNumber = firstSpriteNumber + i;
      explosion->Xco = x;
      explosion->Yco = y;
      explosion->Restart();
    }
    i++;
  }
  return explosion;
}

/***********************/
/* KILL ALL EXPLOSIONS */
/***********************/
void ExplosionManager::KillAllExplosions( void ) {
  for( UInt8 i = 0; i < MaxExplosions; ++i ) {
    explosionPointers[ i ] = (GameObject*)NULL;
  }
}

