/*
 * SOURCE FILE : CharFrame.h
 *
 * For drawing rectangular frames using characters.
 *
 */

#ifndef CharFrameIncluded
  
  #define CharFrameIncluded

  #include "Types.h"    // various types
  #include "Gameduino.h"    // Gameduino stuff
  
  class CharFrame {

  public :
  
    /****************/
    /* DRAW A FRAME */
    /****************/
    // Pass Gameduino to draw on in gd.
    // Pass x coordinate of top left in x.
    // Pass y coordinate of top left in y.
    // Pass width in w.
    // Pass height in h.
    static void Draw( Gameduino *gd, UInt8 x, UInt8 y, UInt8 w, UInt8 h );

    /****************/
    /* WIPE A FRAME */
    /****************/
    // Pass Gameduino to draw on in gd.
    // Pass x coordinate of top left in x.
    // Pass y coordinate of top left in y.
    // Pass width in w.
    // Pass height in h.
    static void Wipe( Gameduino *gd, UInt8 x, UInt8 y, UInt8 w, UInt8 h );

  };
  
#endif

/* END of CharFrame.h */

