/*
 * SOURCE FILE : BrainBulletObject.cpp
 *
 * Definition of class BrainBulletObject.
 *
 */

#include "BrainBulletObject.h"

/***************/
/* CONSTRUCTOR */
/***************/
BrainBulletObject::BrainBulletObject() :
    HVelocity( 0 ),
    VVelocity( 0 )
{
    DeleteWhenRestricted = true;
    RetainOnLevelRestart = false;
    PixelWidth = 4;
    PixelHeight = 4;
}

/************************/
/* DRAW THE GAME OBJECT */
/************************/
// Note if Visible is false this should not draw anything
// and/or hide the visible object.
void BrainBulletObject::Draw( Gameduino *gd ) {
  gd->sprite( SpriteNumber, ToPixel( Xco ), ToPixel( Yco ), BrainBulletImage, 0, Gameduino::None, BadGuy );
}

/************************/
/* MOVE THE GAME OBJECT */
/************************/
void BrainBulletObject::ProtectedMove( void ) {
    Xco += HVelocity;
    Yco += VVelocity;
}
