/*
 * SOURCE FILE : Random.h
 *
 * Definition of class Random.
 * Generates random numbers a bit like the random function used by Arduino and Maple and so on.
 *
 */

#ifndef RandomDefined

  #define RandomDefined

  #include <stdlib.h>
  
  class Random {

  public :

    /***********************/
    /* GET A RANDOM NUMBER */
    /***********************/
    // Get a random number between min and max.
    // Result may be equal to min but is always less than max.
    static long Get( long min, long max ) {
        return min + ( rand() % ( max - min ) );
    }
    
    /***********************/
    /* GET A RANDOM NUMBER */
    /***********************/
    static long Get( long max ) {
        return Get( 0L, max );
    }
        
  };

#endif

/* END of Random.h */

