/*
 * SOURCE FILE : Notes.cpp
 *
 * Enumeration of notes on a piano keyboard and array
 * of notes frequencies for each note.
 *
 */
 
#include "Notes.h"

#define FrequencyConvert( freq ) (UInt16)( freq * 4.0 + 0.5 )

// Array of note frequencies.
const UInt16 Notes::NoteFrequencies[ Notes::NoteCount ] = {
  0,
  0,
  FrequencyConvert( 27.5 ),
  FrequencyConvert( 29.1352350948806 ),
  FrequencyConvert( 30.8677063285078 ),
  FrequencyConvert( 32.7031956625748 ),
  FrequencyConvert( 34.647828872109 ),
  FrequencyConvert( 36.7080959896759 ),
  FrequencyConvert( 38.8908729652601 ),
  FrequencyConvert( 41.2034446141087 ),
  FrequencyConvert( 43.6535289291255 ),
  FrequencyConvert( 46.2493028389543 ),
  FrequencyConvert( 48.9994294977187 ),
  FrequencyConvert( 51.9130871974931 ),
  FrequencyConvert( 55 ),
  FrequencyConvert( 58.2704701897612 ),
  FrequencyConvert( 61.7354126570155 ),
  FrequencyConvert( 65.4063913251497 ),
  FrequencyConvert( 69.295657744218 ),
  FrequencyConvert( 73.4161919793519 ),
  FrequencyConvert( 77.7817459305202 ),
  FrequencyConvert( 82.4068892282175 ),
  FrequencyConvert( 87.307057858251 ),
  FrequencyConvert( 92.4986056779086 ),
  FrequencyConvert( 97.9988589954373 ),
  FrequencyConvert( 103.826174394986 ),
  FrequencyConvert( 110 ),
  FrequencyConvert( 116.540940379522 ),
  FrequencyConvert( 123.470825314031 ),
  FrequencyConvert( 130.812782650299 ),
  FrequencyConvert( 138.591315488436 ),
  FrequencyConvert( 146.832383958704 ),
  FrequencyConvert( 155.56349186104 ),
  FrequencyConvert( 164.813778456435 ),
  FrequencyConvert( 174.614115716502 ),
  FrequencyConvert( 184.997211355817 ),
  FrequencyConvert( 195.997717990875 ),
  FrequencyConvert( 207.652348789973 ),
  FrequencyConvert( 220 ),
  FrequencyConvert( 233.081880759045 ),
  FrequencyConvert( 246.941650628062 ),
  FrequencyConvert( 261.625565300599 ),
  FrequencyConvert( 277.182630976872 ),
  FrequencyConvert( 293.664767917408 ),
  FrequencyConvert( 311.126983722081 ),
  FrequencyConvert( 329.62755691287 ),
  FrequencyConvert( 349.228231433004 ),
  FrequencyConvert( 369.994422711634 ),
  FrequencyConvert( 391.995435981749 ),
  FrequencyConvert( 415.304697579945 ),
  FrequencyConvert( 440 ),
  FrequencyConvert( 466.16376151809 ),
  FrequencyConvert( 493.883301256124 ),
  FrequencyConvert( 523.251130601197 ),
  FrequencyConvert( 554.365261953744 ),
  FrequencyConvert( 587.329535834815 ),
  FrequencyConvert( 622.253967444162 ),
  FrequencyConvert( 659.25511382574 ),
  FrequencyConvert( 698.456462866008 ),
  FrequencyConvert( 739.988845423269 ),
  FrequencyConvert( 783.990871963499 ),
  FrequencyConvert( 830.60939515989 ),
  FrequencyConvert( 880 ),
  FrequencyConvert( 932.32752303618 ),
  FrequencyConvert( 987.766602512248 ),
  FrequencyConvert( 1046.50226120239 ),
  FrequencyConvert( 1108.73052390749 ),
  FrequencyConvert( 1174.65907166963 ),
  FrequencyConvert( 1244.50793488832 ),
  FrequencyConvert( 1318.51022765148 ),
  FrequencyConvert( 1396.91292573202 ),
  FrequencyConvert( 1479.97769084654 ),
  FrequencyConvert( 1567.981743927 ),
  FrequencyConvert( 1661.21879031978 ),
  FrequencyConvert( 1760 ),
  FrequencyConvert( 1864.65504607236 ),
  FrequencyConvert( 1975.5332050245 ),
  FrequencyConvert( 2093.00452240479 ),
  FrequencyConvert( 2217.46104781498 ),
  FrequencyConvert( 2349.31814333926 ),
  FrequencyConvert( 2489.01586977665 ),
  FrequencyConvert( 2637.02045530296 ),
  FrequencyConvert( 2793.82585146403 ),
  FrequencyConvert( 2959.95538169308 ),
  FrequencyConvert( 3135.96348785399 ),
  FrequencyConvert( 3322.43758063956 ),
  FrequencyConvert( 3520 ),
  FrequencyConvert( 3729.31009214472 ),
  FrequencyConvert( 3951.06641004899 ),
  FrequencyConvert( 4186.00904480958 ),
  FrequencyConvert( 4434.92209562995 ),
  FrequencyConvert( 4698.63628667852 ),
  FrequencyConvert( 4978.03173955329 ),
  FrequencyConvert( 5274.04091060592 ),
  FrequencyConvert( 5587.65170292806 ),
  FrequencyConvert( 5919.91076338615 ),
  FrequencyConvert( 6271.92697570799 ),
  FrequencyConvert( 6644.87516127912 ),
};

