/*
 * SOURCE FILE : GameObjectLocator.cpp
 *
 * Code for randomly positioning objects.
 *
 */

#include "GameObjectLocator.h"
#include "ArenaConst.h"
#include "Random.h"

// Indicates which quadrant to put next object in.
UInt8 GameObjectLocator::quad = 0;

/*************************************/
/* POSITION OBJECT RANDOMLY IN ARENA */
/*************************************/
// Pass object to locate in obj.
void GameObjectLocator::Locate( GameObject *obj ) {
  Int16 x, y;
  
  // Calculate start pixel coordinates for player.
  Int16 ppx = GameObject::ToPixel( PLAYER_START_X );
  Int16 ppy = GameObject::ToPixel( PLAYER_START_Y );
  
  // Keep calculating random coordinates until coordinates chosen
  // are some distance away from chase object.
  do {
    
    x = Random::Get( ( ARENA_WIDTH >> 1 ) - SPRITE_PIXEL_WIDTH - 4 );
    y = Random::Get( ( ARENA_HEIGHT >> 1 ) - SPRITE_PIXEL_HEIGHT - 4 );
    
    switch( quad ) {
      
    case 0 :
      x += ARENA_MIN_X;
      y += ARENA_MIN_Y;
      break;
      
    case 1 :
      x = ARENA_MIN_X + ARENA_WIDTH - SPRITE_PIXEL_WIDTH - x;
      y += ARENA_MIN_Y;
      break;
      
    case 2 :
      x += ARENA_MIN_X;
      y = ARENA_MIN_Y + ARENA_HEIGHT - SPRITE_PIXEL_HEIGHT - y;
      break;
      
    case 3 :
      x = ARENA_MIN_X + ARENA_WIDTH - SPRITE_PIXEL_WIDTH - x;
      y = ARENA_MIN_Y + ARENA_HEIGHT - SPRITE_PIXEL_HEIGHT - y;
      break;

    }
    
  } while(
    ( abs( x - ppx ) < ( SPRITE_PIXEL_WIDTH << 1 ) ) &&
    ( abs( y - ppy ) < ( SPRITE_PIXEL_HEIGHT << 1 ) )
  );
  
  obj->Xco = GameObject::FromPixel( x );
  obj->Yco = GameObject::FromPixel( y );

  // Use next quadrant on next call.
  quad++;
  quad &= 3;
  
}


