/*
 * SOURCE FILE : GDExtra.h
 *
 * Additional routines for the Gameduino.
 *
 */

#ifndef GDExtraIncluded
  
  #define GDExtraIncluded

  #include "Gameduino.h"       // Gameduino stuff
  #include "Types.h"           // various types
  
  class GDExtra {
    
  public :
  
    /****************/
    /* CLEAR SCREEN */
    /****************/
    // Pass pointer to a Gameduino in gd.
    // Writes all character RAM with given character code.
    static void ClearScreen( Gameduino *gd, UInt8 code );

    /************************/
    /* HIDE A SINGLE SPRITE */
    /************************/
    // Pass pointer to a Gameduino in gd.
    // Pass sprite number in spriteNumber parameter.
    static void HideSprite( Gameduino *gd, UInt8 spriteNumber );
        
    /********************/
    /* HIDE ALL SPRITES */
    /********************/
    // Pass pointer to a Gameduino in gd.
    static void HideAllSprites( Gameduino *gd );
    
    /*********************************************/
    /* DISPLAY A STRING STORED IN PROGRAM MEMORY */
    /*********************************************/
    // Pass pointer to a Gameduino in gd.
    // Pass coordinates in x and y.
    // Pass address of string in s.
    static void WriteProgString( Gameduino *gd, UInt8 x, UInt8 y, const char *s );
    
    /*******************************/
    /* DISPLAY AN UNSIGNED INTEGER */
    /*******************************/
    // Pass pointer to a Gameduino in gd.
    // Pass coordinates in x and y.
    // Pass number to write in num.
    // Pass numeric base in base.
    // Pass number of digits to write in digits.
    static void WriteUInt16( Gameduino *gd, UInt8 x, UInt8 y, UInt16 num, UInt8 base, UInt8 digits );

    /************************/
    /* DISPLAY A BCD NUMBER */
    /************************/
    // Pass pointer to a Gameduino in gd.
    // Pass coordinates in x and y.
    // Pass number to write in num.
    // Pass number of digits to write in digits.
    static void WriteBCDNumber( Gameduino *gd, UInt8 x, UInt8 y, UInt32 num, UInt8 digits );
    
    /******************************************************/
    /* DISPLAY A CHARACTER BLOCK STORED IN PROGRAM MEMORY */
    /******************************************************/
    // Pass pointer to a Gameduino in gd.
    // Pass coordinates in x and y.
    // Pass address of character block in bPtr.
    // Address points to the width of the block, followed by the height of
    // the block and then the character codes that make up the block.
    static void WriteProgCharBlock( Gameduino *gd, UInt8 x, UInt8 y, const UInt8 *bPtr );
    
  };
  
#endif

/* END of GDExtra.h */


