/*
 * SOURCE FILE : FieldGrid.cpp
 *
 * Definition of class FieldGrid.
 * This is a grid of rectangles used for fields on a form or whatever.
 *
 */

#include "FieldGrid.h"

/***************/
/* CONSTRUCTOR */
/***************/
// Pass number of rows in grid in rc.
FieldGrid::FieldGrid( UInt8 rc ) :
    rows( new FieldRow[ rc ] ),
    rowCount( rc )
{
}

/**************/
/* DESTRUCTOR */
/**************/
FieldGrid::~FieldGrid() {
    delete [] rows;
}

/*************/
/* GET A ROW */
/*************/
// Pass row number in rowNum.
// Returns pointer to row or NULL if no such row.
FieldRow *FieldGrid::GetRow( UInt8 rowNum ) {
    if( rowNum < rowCount ) {
        return rows + rowNum;
    }
    else {
        return (FieldRow*)NULL;
    }
}

