/*
 * SOURCE FILE : ExplosionObject.h
 *
 * Represents an explosion.
 *
 */

#ifndef ExplosionObjectIncluded
  
  #define ExplosionObjectIncluded

  #include "OneShotObject.h"
  #include "SpriteImageId.h"
  
  class ExplosionObject : public OneShotObject {
    
  public :

    /***************/
    /* CONSTRUCTOR */
    /***************/
    ExplosionObject() {
      SetImageRange( Explosion0Image, Explosion9Image, 7 );
    }

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~ExplosionObject() {
    }
    
    /************************/
    /* GET GAME OBJECT TYPE */
    /************************/
    // Returns type of game object.
    virtual GameObjectTypes GetType( void ) {
      return ExplosionObjectType;
    }
    
  };
    
#endif

/* END of ExplosionObject.h */

