/*
 * SOURCE FILE : CrusherObject.h
 *
 * Represents a wandering human.
 *
 */

#ifndef CrusherObjectIncluded
  
  #define CrusherObjectIncluded

  #include "Types.h"
  #include "EnemyObject.h"
  #include "GameObjectTypes.h"

  class CrusherObject : public EnemyObject {
    
  public :

    /***************/
    /* CONSTRUCTOR */
    /***************/
    CrusherObject();
    
    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~CrusherObject();

    /*****************************/
    /* GET TYPE OF ENEMY THIS IS */
    /*****************************/
    // Returns enemy type.
    virtual EnemyType GetEnemyType( void ) {
        return Crusher;
    }

    /*******************************************************/
    /* GET NUMBER OF POINTS AWARDED FOR KILLING THIS ENEMY */
    /*******************************************************/
    // Returns number of points.
    virtual UInt8 GetPoints( void ) {
      return 0x10;  // BCD!
    }

    /************************/
    /* MOVE THE GAME OBJECT */
    /************************/
    virtual void ProtectedMove( void );

    /************************/
    /* DRAW THE GAME OBJECT */
    /************************/
    // Pass pointer to a Gameduino to draw on in gd.
    // This is only called after it has been established that the
    // game object is visible.
    virtual void Draw( Gameduino *gd );
   
    /********************************************/
    /* INFORM ENEMY IT HAS BEEN HIT BY A BULLET */
    /********************************************/
    // Default implementation does nothing but if special behaviour
    // is required in a derived class then this should be overridden.
    // Note that this does NOT deal with determining if the enemy is dead or not.
    // An enemy ALWAYS dies if HitPoints reaches zero.
    virtual void RegisterHitByBullet( void );

  private :

    // Address of animation data in program memory.
    const UInt8 *animationData;
    
    // Horizontal and vertical velocities.
    Int16 hSpeed, vSpeed;

    // Stun countdown. Crusher does not move until this reaches zero.
    UInt8 stunCountdown;
    
    // Frame count at the moment crusher was stunned.
    UInt8 stunFrameCount;
        
  };
    
#endif

/* END of CrusherObject.h */

