/*
 * SOURCE FILE : BulletManager.h
 *
 * Responsible for managing a collection of bullets.
 *
 */

#ifndef BulletManagerIncluded
  
  #define BulletManagerIncluded
  
  #include "Types.h"
  #include "BulletObject.h"
  #include "Gameduino.h"
  
  class BulletManager {
  
  public :

    enum {
      MaxBullets = 20,    // maximum number of bullets on the go at one tine.
    };
    
    /***************/
    /* CONSTRUCTOR */
    /***************/
    // Pass number of sprite to use for first bullet.
    // MaxBullets consequtive sprites will be used for bullets.
    BulletManager( UInt8 firstSpriteNumber );
    
    /**********************/
    /* START A BULLET OFF */
    /**********************/
    // Pass start coordinates in x and y (NOT pixel coordinates).
    // Pass bullet velocities in hv and vv (NOT pixel velocities).
    // Returns true if bullet was started successfully.
    bool StartBullet( Int16 x, Int16 y, Int16 hv, Int16 vv );
    
    /************************/
    /* KILL A SINGLE BULLET */
    /************************/
    // Pass pointer to Gameduino that displays bullets in gd.
    // Pass index of bullet in b.
    void KillBullet( Gameduino *gd, UInt8 b );

    /********************/
    /* KILL ALL BULLETS */
    /********************/
    // Pass pointer to Gameduino that displays bullets in gd.
    void KillAllBullets( Gameduino *gd );
    
    /************************************************/
    /* GET ARRAY CONTAINING POINTERS TO ALL BULLETS */
    /************************************************/
    // Returns pointer to array of GameObject pointers.
    // The array has BulletManager::MaxBullets pointers in it.
    GameObject **GetBullets( void ) {
      return bulletPointers;
    }
    
  private :

    // All the bullets.
    BulletObject bullets[ MaxBullets ];

    // Pointers to all the bullets.
    // Entries in this array will be NULL for bullets that are not active.
    // When bullet is active it will point to the corresponding entry in the bullets array.
    GameObject *bulletPointers[ MaxBullets ];
    
  };
  
#endif

/* END of BulletManager.h */

