/*
 * SOURCE FILE : BlueMeanyObject.cpp
 *
 * Represents the BlueMeany enemy object.
 *
 */

#include "BlueMeanyObject.h"
#include "MathFuncs.h"

/************************/
/* MOVE THE GAME OBJECT */
/************************/
void BlueMeanyObject::ProtectedMove( void ) {
  // If being restricted horizontally then make horizontal velocity zero.
  if( RestrictionFlags & ( LeftRestriction | RightRestriction ) ) {
    hVelocity = 0;
  }
  // If being restricted vertically then make vertical velocity zero.
  if( RestrictionFlags & ( UpRestriction | DownRestriction ) ) {
    vVelocity = 0;
  }
  // Update coordinates by adding velocities.
  Xco += hVelocity;
  Yco += vVelocity;
  // Accelerate towards chase object horizontally.
  if( Xco > chaseObject->Xco ) {
    hVelocity--;
  }
  else {
    hVelocity++;
  }
  // Accelerate towards chase object vertically.
  if( Yco > chaseObject->Yco ) {
    vVelocity--;
  }
  else {
    vVelocity++;
  }
  // Don't let speed get too fast.
  hVelocity = MathFuncs::Constrain( hVelocity, -MaxBlueMeanyVelocity, MaxBlueMeanyVelocity );
  vVelocity = MathFuncs::Constrain( vVelocity, -MaxBlueMeanyVelocity, MaxBlueMeanyVelocity );
}
