/*
 * SOURCE FILE : Notes.h
 *
 * Enumeration of notes on a piano keyboard and array
 * of notes frequencies for each note.
 *
 */
 
#ifndef NotesIncluded

  #define NotesIncluded

  #include "Types.h"
  
  class Notes {
  
  public :

    enum NoteId {
      
      NoteEndMarker,
      NoteSilent,
      
      NoteA0,
      NoteAS0,
      NoteB0,
      NoteC0,
      NoteCS0,
      NoteD0,
      NoteDS0,
      NoteE0,
      NoteF0,
      NoteFS0,
      NoteG0,
      NoteGS0,
      
      NoteA1,
      NoteAS1,
      NoteB1,
      NoteC1,
      NoteCS1,
      NoteD1,
      NoteDS1,
      NoteE1,
      NoteF1,
      NoteFS1,
      NoteG1,
      NoteGS1,
      
      NoteA2,
      NoteAS2,
      NoteB2,
      NoteC2,
      NoteCS2,
      NoteD2,
      NoteDS2,
      NoteE2,
      NoteF2,
      NoteFS2,
      NoteG2,
      NoteGS2,
      
      NoteA3,
      NoteAS3,
      NoteB3,
      NoteC3,
      NoteCS3,
      NoteD3,
      NoteDS3,
      NoteE3,
      NoteF3,
      NoteFS3,
      NoteG3,
      NoteGS3,
      
      NoteA4,
      NoteAS4,
      NoteB4,
      NoteC4,
      NoteCS4,
      NoteD4,
      NoteDS4,
      NoteE4,
      NoteF4,
      NoteFS4,
      NoteG4,
      NoteGS4,
      
      NoteA5,
      NoteAS5,
      NoteB5,
      NoteC5,
      NoteCS5,
      NoteD5,
      NoteDS5,
      NoteE5,
      NoteF5,
      NoteFS5,
      NoteG5,
      NoteGS5,

      NoteA6,
      NoteAS6,
      NoteB6,
      NoteC6,
      NoteCS6,
      NoteD6,
      NoteDS6,
      NoteE6,
      NoteF6,
      NoteFS6,
      NoteG6,
      NoteGS6,

      NoteA7,
      NoteAS7,
      NoteB7,
      NoteC7,
      NoteCS7,
      NoteD7,
      NoteDS7,
      NoteE7,
      NoteF7,
      NoteFS7,
      NoteG7,
      NoteGS7,

      NoteCount      // MUST COME LAST!
    };
    
    // Array of note frequencies.
    static const UInt16 NoteFrequencies[ NoteCount ];
    
  };
  
#endif

// End of Notes.h

