/*
 * SOURCE FILE : HumanObject.h
 *
 * Represents a wandering human.
 *
 */

#ifndef HumanObjectIncluded
  
  #define HumanObjectIncluded

  #include "Types.h"
  #include "GameObject.h"
  #include "GameObjectTypes.h"

  class HumanObject : public GameObject {
    
  public :

    // States a human can be in.
    // Each human starts in the WalkingAbout state and keeps wandering around as
    // long as it is in this state.
    // If the player touches a human than it changes to the Rescued state and
    // it stops walking and its  appearance changes to show the number of points
    // awarded. Eventually this disappears and the Visible property inherited from
    // GameObject is set to false. On next draw the human will be removed from the
    // array of humans and replaced with NULL.
    enum State {
      WalkingAbout,
      Rescued,
            Dead,
    };
    
        // Different kinds of human.
        enum HumanType {
            Woman,
            Man,
        };
        
    // Current state of human.
    State CurrentState;
    
    /***************/
    /* CONSTRUCTOR */
    /***************/
    HumanObject();
    
    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~HumanObject();

    /************************/
    /* GET GAME OBJECT TYPE */
    /************************/
    // Returns type of game object.
    virtual GameObjectTypes GetType( void ) {
      return HumanObjectType;
    }

        /*****************************/
        /* GET TYPE OF HUMAN THIS IS */
        /*****************************/
        // Returns type of human.
        HumanType GetHumanType( void );
        
    /************************/
    /* MOVE THE GAME OBJECT */
    /************************/
    virtual void ProtectedMove( void );

    /************************/
    /* DRAW THE GAME OBJECT */
    /************************/
    // Pass pointer to Gameduino to draw on in gd.
    // This is only called after it has been established that the
    // game object is visible.
    virtual void Draw( Gameduino *gd );
   
  private :

    // Address of animation data in program memory.
    const UInt8 *animationData;
    
    // Horizontal and vertical velocities.
    Int16 hSpeed, vSpeed;

    // Countdown used when in rescued or dead states.
    UInt8 countdown;
    
    // Index of next animation to use when constructing.
    // Cycles around all human animations.
    static UInt8 nextAnimationIndex;
    
  };
    
#endif

/* END of HumanObject.h */

