/*
 * SOURCE FILE : FieldCell.h
 *
 * Definition of class FieldCell.
 *
 */

#ifndef FieldCellDefined

  #define FieldCellDefined

  #include <stdlib.h>           // for NULL
  #include "Rectangle.h"
  
  class FieldCell {

  public :

    // Rectangle which cell covers.
    // Specified in pixel coordinates.
    Rectangle Rect;
    
    /***************/
    /* CONSTRUCTOR */
    /***************/
    FieldCell();

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~FieldCell();

    /************************/
    /* GET NEXT CELL IN ROW */
    /************************/
    FieldCell *GetNext( void ) const {
        return nextCell;
    }
    
    /************************/
    /* SET NEXT CELL IN ROW */
    /************************/
    // Pass pointer to next cell in cell.
    void SetNext( FieldCell *cell ) {
        nextCell = cell;
    }
    
  private :

    // Pointer to next cell in row. NULL if last cell in row.
    FieldCell *nextCell;
      
  };

#endif

/* END of FieldCell.h */


