/*
 * SOURCE FILE : ExplosionManager.h
 *
 * Responsible for managing a collection of explosions.
 *
 */

#ifndef ExplosionManagerIncluded
  
  #define ExplosionManagerIncluded
  
  #include "Types.h"
  #include "ExplosionObject.h"
  
  class ExplosionManager {
  
  public :

    // An instance of this class.
    static ExplosionManager Instance;
    
    enum {
      MaxExplosions = 10,
    };
    
    /***************/
    /* CONSTRUCTOR */
    /***************/
        // Pass index of first sprite used for explosions in fsn.
    ExplosionManager( UInt8 fsn );
    
    /**************/
    /* DESTRUCTOR */
    /**************/
    ~ExplosionManager();

    /**************************/
    /* START AN EXPLOSION OFF */
    /**************************/
    // Pass start coordinates in x and y (NOT pixel coordinates).
    // Returns pointer to an ExplosionObject if it was started successfully or NULL if
    // no more explosions are available at the moment.
    ExplosionObject *StartExplosion( Int16 x, Int16 y );
    
    /***********************/
    /* KILL ALL EXPLOSIONS */
    /***********************/
    void KillAllExplosions( void );
    
    /**********************************************/
    /* GET ARRAY OF POINTERS TO EXPLOSION OBJECTS */
    /**********************************************/
    // Returns an array of pointers containing MaxExplosions items.
    GameObject **GetExplosions( void ) {
      return explosionPointers;
    }

  private :

        // Sprite number for first sprite used for explosions.
        UInt8 firstSpriteNumber;
        
    // Bank of explosion objects.
    ExplosionObject explosions[ MaxExplosions ];
    
    // Pointers to explosion objects.
    GameObject *explosionPointers[ MaxExplosions ];

  };
  
#endif

/* END of ExplosionManager.h */

