/*
 * SOURCE FILE : EnemyFactory.h
 *
 * Definition of class EnemyFactory.
 * Makes objects descended from EnemyObject.
 * It is absolutely vital that all enemies are created and deleted this way if memory leaks are to be avoided.
 * Don't forget pesky enemies like MutantObjects that only appear half way through a level. They still need
 * to be created this way.
 *
 */

#ifndef EnemyFactoryDefined

  #define EnemyFactoryDefined

  #include "EnemyType.h"
  #include "GameObject.h"
  #include "HumanObject.h"
  #include "GruntObject.h"
  #include "CrusherObject.h"
  #include "BrainObject.h"
  #include "MutantObject.h"
  #include "BlueMeanyObject.h"

  class EnemyFactory {

  public :

    // An instance of this class.
    static EnemyFactory Instance;
    
    /***************/
    /* CONSTRUCTOR */
    /***************/
    EnemyFactory();

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~EnemyFactory();

    /*****************/
    /* MAKE AN ENEMY */
    /*****************/
    // Pass enemy type in et.
    // Returns a newly created object or NULL on failure.
    EnemyObject* MakeEnemy( EnemyType et );

    /*******************/
    /* DELETE AN ENEMY */
    /*******************/
    // Pass pointer to enemy to delete.
    // ONLY USE THIS ON OBJECTS CREATED USING MakeEnemy method.
    void DeleteEnemy( EnemyObject *enemy );

  private :
  
    // Number of enemies created.
    unsigned long enemyCount;
        
  };

#endif

/* END of EnemyFactory.h */


