/*
 * SOURCE FILE : BulletObject.h
 *
 * Represents a bullet type objects with horizontal and vertical velocities.
 *
 */

#ifndef BulletObjectIncluded
  
  #define BulletObjectIncluded

  #include "Gameduino.h"
  #include "GameObject.h"
  #include "SpriteImageId.h"
  #include "SpriteGroup.h"

  class BulletObject : public GameObject {
    
  public :

    /***************/
    /* CONSTRUCTOR */
    /***************/
    BulletObject() :
      imageNumber( PlayerBulletImage ),
      spriteGroup( GoodGuy )
    {
      DeleteWhenRestricted = true;
    }
    
    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~BulletObject() {
    }
    
    /************************/
    /* GET GAME OBJECT TYPE */
    /************************/
    // Returns type of game object.
    virtual GameObjectTypes GetType( void ) {
      return BulletObjectType;
    }

    /****************/
    /* START BULLET */
    /****************/
    void Start( Int16 x, Int16 y, Int16 hv, Int16 vv ) {
      Xco = x;
      Yco = y;
      hSpeed = hv;
      vSpeed = vv;
      Visible = true;
    }
    
    /************************/
    /* MOVE THE GAME OBJECT */
    /************************/
    virtual void ProtectedMove( void ) {
      Xco += hSpeed;
      Yco += vSpeed;
    }

    /************************/
    /* DRAW THE GAME OBJECT */
    /************************/
    // Pass pointer to Gameduino to draw on in gd.
    // This is only called after it has been established that the
    // game object is visible.
    virtual void Draw( Gameduino *gd ) {
      gd->sprite( SpriteNumber, ToPixel( Xco ), ToPixel( Yco ), imageNumber, 0, Gameduino::None, spriteGroup );
    }
   
  private :

    // Number of sprite image used for bullet.
    SpriteImageId imageNumber;

    // Indicates whether these are good or bad bullets for
    // purposes of collision detection.
    SpriteGroup spriteGroup;
    
    // Horizontal and vertical velocities.
    Int16 hSpeed, vSpeed;

  };
    
#endif

/* END of BulletObject.h */

