/*
 * SOURCE FILE : BrainObject.h
 *
 * Represents a wandering human.
 *
 */

#ifndef BrainObjectIncluded
  
  #define BrainObjectIncluded

  #include "Types.h"
  #include "EnemyObject.h"
  #include "GameObjectTypes.h"
  #include "BrainBulletObject.h"

  class BrainObject : public EnemyObject {
    
  public :

        // Points to an array of humans to chase.
        GameObject **HumansToChase;
        
        /***************/
        /* CONSTRUCTOR */
        /***************/
        BrainObject();
        
        /**************/
        /* DESTRUCTOR */
        /**************/
        virtual ~BrainObject();

        /*****************************/
        /* GET TYPE OF ENEMY THIS IS */
        /*****************************/
        // Returns enemy type.
        virtual EnemyType GetEnemyType( void ) {
            return Brain;
        }

        /*******************************************************/
        /* GET NUMBER OF POINTS AWARDED FOR KILLING THIS ENEMY */
        /*******************************************************/
        // Returns number of points.
        virtual UInt8 GetPoints( void ) {
          return 0x20;  // BCD!
        }
    
        /************************/
        /* MOVE THE GAME OBJECT */
        /************************/
        virtual void ProtectedMove( void );
    
        /************************/
        /* DRAW THE GAME OBJECT */
        /************************/
        // This is only called after it has been established that the
        // game object is visible.
        virtual void Draw( Gameduino *gd );
   
    private :

        enum {
            BrainSpeed = 24,              // speed at which brains move towards their prey
        };
        
        bool bulletActive;                // true if a bullet fired by this brain is zipping around
        UInt8 bulletIndex;                // index of active bullet in enemies array
        
        /******************************************************/
        /* DETERMINE IF A HUMAN IS A VALID TARGET FOR A BRAIN */
        /******************************************************/
        // Returns true if object is a human that is valid for targeting by brain.
        static bool ValidHuman( GameObject *object );

        /******************/
        /* START A BULLET */
        /******************/
        // Pass sprite number to use in spriteNumber.
        // Returns pointer to bullet object or NULL on failure.
        BrainBulletObject *StartBullet( UInt8 spriteNumber );

  };
    
#endif

/* END of BrainObject.h */

