/*
 * SOURCE FILE : BlueMeanyObject.h
 *
 * Represents the BlueMeany enemy object.
 *
 */

#ifndef BlueMeanyObjectIncluded
  
  #define BlueMeanyObjectIncluded

  #include "EnemyObject.h"
  #include "SpriteImageId.h"
  #include "FrameCounter.h"
  
  class BlueMeanyObject : public EnemyObject {
    
  public :

    /***************/
    /* CONSTRUCTOR */
    /***************/
    BlueMeanyObject() :
      hVelocity( 0 ),
      vVelocity( 0 )
    {
    }

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~BlueMeanyObject() {
    }
    
    /*****************************/
    /* GET TYPE OF ENEMY THIS IS */
    /*****************************/
    // Returns enemy type.
    virtual EnemyType GetEnemyType( void ) {
        return BlueMeany;
    }

    /*******************************************************/
    /* GET NUMBER OF POINTS AWARDED FOR KILLING THIS ENEMY */
    /*******************************************************/
    // Returns number of points.
    virtual UInt8 GetPoints( void ) {
      return 0x10;  // BCD!
    }

    /*****************************************************************/
    /* PERFORM ANY INIITALISATION REQUIRED AT LEVEL START OR RESTART */
    /*****************************************************************/
    // Derived classes should override this if necessary.
    virtual void LevelRestart( void ) {
        // Bring Blue Meany to a halt at the start of the level.
        hVelocity = 0;
        vVelocity = 0;
    }
    
    /************************/
    /* MOVE THE GAME OBJECT */
    /************************/
    virtual void ProtectedMove( void );

    /************************/
    /* DRAW THE GAME OBJECT */
    /************************/
    // This is only called after it has been established that the
    // game object is visible.
    virtual void Draw( Gameduino *gd ) {
      Gameduino::Rotation transform = ( Xco < chaseObject->Xco ) ? Gameduino::FlipX : Gameduino::None;
      gd->sprite( SpriteNumber, ToPixel( Xco ), ToPixel( Yco ), BlueMeanyImage, 0, transform, BadGuy );
    }
   
  private :
  
        enum {
            MaxBlueMeanyVelocity = 64,
        };
        
    // Horizontal and vertical velocities. NOT in pixels.
    Int16 hVelocity, vVelocity;
    
  };
    
#endif

/* END of BlueMeanyObject.h */
