/*
 * SOURCE FILE : Walker.h
 *
 * Methods for objects that walk sideways on (like humans and crushers).
 *
 */

#ifndef WalkerDefined

  #define WalkerDefined

    #include "Types.h"
    #include "GameObject.h"
    
  class Walker {

  public :

    enum {
      AnimationStages = 4,
    };

        /*************************************************/
        /* INITIALISE HORIZONTAL AND VERTICAL VELOCITIES */
        /*************************************************/
        // Pass pointers to horizontal and vertical velocities in hv and vv.
        static void InitialiseVelocities( Int16 *hv, Int16 *vv );
        
        /*********************************************************/
        /* UPDATE COORDINATES AND VELOCITIES TO MAKE OBJECT WALK */
        /*********************************************************/
        // Pass pointers to x and y coordinates in x and y.
        // Pass pointers to horizontal and vertical velocities in hv and vv.
        // Pass restriction flags (as defined in GameObject.h) in restriction Flags.
        static void Walk( Int16 *x, Int16 *y, Int16 *hv, Int16 *vv, UInt8 restrictionFlags );
        
        /*************************/
        /* DRAW A WALKING OBJECT */
        /*************************/
        // Pass pointer to Gameduino to draw on in gd.
        // Pass sprite number in spriteNumber.
        // Pass x and y coordinates in x and y (NOT pixel coordinates).
        // Pass horizontal velocity in hv.
        // Pass counter used to pace animation in frameCounter.
        // Pass pointer to animation data (array of AnimationStages sprite image numbers) in animationData.
        static void Draw( Gameduino *gd, UInt8 spriteNumber, Int16 x, Int16 y, Int16 hv, UInt8 frameCounter, const UInt8 *animationData );
        
    private :
    
        };

#endif

/* END of Walker.h */

