/*
 * SOURCE FILE : SpriteNumber.h
 *
 * Enumeration containing sprite numbers.
 * Note that these are sprite numbers, NOT sprite image numbers.
 * Each sprite can have any sprite image number it wants.
 *
 */

#ifndef SpriteNumberDefined

  #define SpriteNumberDefined

  #include "LevelData.h"
  #include "ExplosionManager.h"
    
  enum SpriteNumber {
        FirstEnemySprite = 0,
        FirstHumanSprite = FirstEnemySprite + LevelData::MaxEnemies,
        PlayerSprite = FirstHumanSprite + LevelData::MaxHumans,
        FirstExplosionSprite = PlayerSprite + 1,
        NextFreeSprite = FirstExplosionSprite + ExplosionManager::MaxExplosions,
  };

#endif

/* END of SpriteNumber.h */
