/*
 * SOURCE FILE : RobotRicCharacterSet.cpp
 *
 * Contains character set data for RobotRic game.
 *
 */

#include "RobotRicCharacterSet.h"

PROGMEM prog_uchar RobotRicCharacterSet::PixelData[] = {
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // Character 0
0x00, 0x00, 0x15, 0x55, 0x1A, 0xAA, 0x1B, 0xFF, 0x1B, 0xFF, 0x1B, 0xEA, 0x1B, 0xE5, 0x1B, 0xE4, // Character 1
0x00, 0x00, 0x55, 0x55, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0x55, 0x55, 0x00, 0x00, // Character 2
0x00, 0x00, 0x55, 0x54, 0xAA, 0xA4, 0xFF, 0xE4, 0xFF, 0xE4, 0xAB, 0xE4, 0x5B, 0xE4, 0x1B, 0xE4, // Character 3
0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, // Character 4
0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, // Character 5
0x1B, 0xE4, 0x1B, 0xE5, 0x1B, 0xEA, 0x1B, 0xFF, 0x1B, 0xFF, 0x1A, 0xAA, 0x15, 0x55, 0x00, 0x00, // Character 6
0x00, 0x00, 0x55, 0x55, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0x55, 0x55, 0x00, 0x00, // Character 7
0x1B, 0xE4, 0x5B, 0xE4, 0xAB, 0xE4, 0xFF, 0xE4, 0xFF, 0xE4, 0xAA, 0xA4, 0x55, 0x54, 0x00, 0x00, // Character 8
0xFC, 0x0F, 0xF6, 0xA7, 0xFC, 0x0F, 0xC0, 0x00, 0xDC, 0x0D, 0xFC, 0xCF, 0xF5, 0xD7, 0xFF, 0xFF, // Character 9
0x1B, 0xE4, 0x1B, 0xE5, 0x1B, 0xEA, 0x1B, 0xFF, 0x1B, 0xFF, 0x1B, 0xEA, 0x1B, 0xE5, 0x1B, 0xE4, // Character 10
0x00, 0x00, 0x55, 0x55, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xAB, 0xEA, 0x5B, 0xE5, 0x1B, 0xE4, // Character 11
0x1B, 0xE4, 0x5B, 0xE4, 0xAB, 0xE4, 0xFF, 0xE4, 0xFF, 0xE4, 0xAB, 0xE4, 0x5B, 0xE4, 0x1B, 0xE4, // Character 12
0x1B, 0xE4, 0x5B, 0xE5, 0xAB, 0xEA, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0x55, 0x55, 0x00, 0x00, // Character 13
0x00, 0x00, 0x15, 0x55, 0x1A, 0xAA, 0x1B, 0xFF, 0x1B, 0xFF, 0x1A, 0xAA, 0x15, 0x55, 0x00, 0x00, // Character 14
0x00, 0x00, 0x15, 0x54, 0x1A, 0xA4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, // Character 15
0x00, 0x00, 0x55, 0x54, 0xAA, 0xA4, 0xFF, 0xE4, 0xFF, 0xE4, 0xAA, 0xA4, 0x55, 0x54, 0x00, 0x00, // Character 16
0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1B, 0xE4, 0x1A, 0xA4, 0x15, 0x54, 0x00, 0x00, // Character 17
0xFC, 0x3F, 0xFC, 0x3F, 0xF1, 0x4F, 0xF1, 0x4F, 0xC6, 0x93, 0xC6, 0x93, 0x15, 0x54, 0x00, 0x00, // Character 18
0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // Character 19
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 20
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 21
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 22
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 23
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 24
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 25
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 26
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 27
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 28
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 29
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 30
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 31
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // Character 32 ( )
0xFC, 0x1F, 0xFC, 0x1F, 0xFC, 0x1F, 0xFC, 0x1F, 0xFF, 0x5F, 0xFC, 0x3F, 0xFC, 0x1F, 0xFF, 0x5F, // Character 33 (!)
0xC3, 0xC3, 0xC1, 0xC1, 0xC1, 0xC1, 0xF5, 0xF5, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // Character 34 (")
0xC3, 0x0F, 0x00, 0x03, 0x00, 0x01, 0xC1, 0x05, 0x00, 0x03, 0x00, 0x01, 0xC1, 0x05, 0xF5, 0xD7, // Character 35 (#)
0x00, 0x03, 0x00, 0x01, 0x04, 0x55, 0x00, 0x01, 0xD4, 0x41, 0x00, 0x01, 0x00, 0x01, 0xD5, 0x55, // Character 36 ($)
0xFF, 0xFF, 0xC3, 0xF3, 0xC1, 0xC5, 0xF5, 0x17, 0xFC, 0x5F, 0xF1, 0x43, 0xC5, 0xC1, 0xF7, 0xF5, // Character 37 (%)
0xFF, 0xFF, 0x00, 0x03, 0x00, 0x01, 0xD5, 0x55, 0x00, 0x03, 0x00, 0x01, 0xD5, 0x55, 0xFF, 0xFF, // Character 38 (&)
0xFC, 0x3F, 0xFC, 0x1F, 0xFC, 0x1F, 0xFF, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // Character 39 (')
0xFC, 0x0F, 0xF0, 0x07, 0xF0, 0x57, 0xF0, 0x7F, 0xF0, 0x7F, 0xF0, 0x0F, 0xFC, 0x07, 0xFF, 0x57, // Character 40 (()
0xF0, 0x3F, 0xF0, 0x0F, 0xFD, 0x07, 0xFF, 0x07, 0xFF, 0x07, 0xF0, 0x07, 0xF0, 0x17, 0xFD, 0x5F, // Character 41 ())
0xFC, 0xFF, 0xCC, 0x4F, 0xF0, 0x17, 0x00, 0x03, 0xF0, 0x15, 0xC4, 0x4F, 0xF4, 0x77, 0xFF, 0x7F, // Character 42 (*)
0xFF, 0xFF, 0xFC, 0x3F, 0xFC, 0x1F, 0xC0, 0x03, 0xC0, 0x01, 0xF4, 0x15, 0xFC, 0x1F, 0xFF, 0x5F, // Character 43 (+)
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFC, 0x1F, 0xFF, 0x1F, 0xFF, 0x5F, // Character 44 (,)
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x03, 0xC0, 0x01, 0xF5, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, // Character 45 (-)
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFC, 0x1F, 0xFF, 0x5F, // Character 46 (.)
0xFF, 0xC3, 0xFF, 0x01, 0xFC, 0x05, 0xF0, 0x17, 0xC0, 0x5F, 0x01, 0x7F, 0x05, 0xFF, 0xD7, 0xFF, // Character 47 (/)
0x00, 0x03, 0x00, 0x01, 0x07, 0xC1, 0x07, 0xC1, 0x07, 0xC1, 0x00, 0x01, 0x00, 0x01, 0xD5, 0x55, // Character 48 (0)
0xF0, 0x0F, 0xF0, 0x07, 0xF0, 0x07, 0xF0, 0x07, 0xF0, 0x07, 0xF0, 0x07, 0xF0, 0x07, 0xFD, 0x57, // Character 49 (1)
0x00, 0x03, 0x00, 0x01, 0xD5, 0x41, 0x00, 0x01, 0x05, 0x55, 0x00, 0x01, 0x00, 0x01, 0xD5, 0x55, // Character 50 (2)
0x00, 0x03, 0x00, 0x01, 0xD5, 0x41, 0x00, 0x01, 0xD5, 0x41, 0x00, 0x01, 0x00, 0x01, 0xD5, 0x55, // Character 51 (3)
0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00, 0x01, 0xD5, 0x01, 0xFF, 0x01, 0xFF, 0xD5, // Character 52 (4)
0x00, 0x03, 0x00, 0x01, 0x05, 0x55, 0x00, 0x01, 0xD5, 0x41, 0x00, 0x01, 0x00, 0x01, 0xD5, 0x55, // Character 53 (5)
0x00, 0x03, 0x00, 0x01, 0x05, 0x55, 0x00, 0x01, 0x05, 0x41, 0x00, 0x01, 0x00, 0x01, 0xD5, 0x55, // Character 54 (6)
0x00, 0x03, 0x00, 0x01, 0xD5, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0xF5, // Character 55 (7)
0x00, 0x03, 0x00, 0x01, 0x05, 0x41, 0x00, 0x01, 0x05, 0x41, 0x00, 0x01, 0x00, 0x01, 0xD5, 0x55, // Character 56 (8)
0x00, 0x03, 0x00, 0x01, 0x05, 0x41, 0x00, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0xD5, // Character 57 (9)
0xF0, 0x0F, 0xF0, 0x07, 0xF0, 0x07, 0xFD, 0x57, 0xF0, 0x0F, 0xF0, 0x07, 0xF0, 0x07, 0xFD, 0x57, // Character 58 (:)
0xF0, 0x0F, 0xF0, 0x07, 0xF0, 0x07, 0xFD, 0x57, 0xF0, 0x0F, 0xF0, 0x07, 0xFD, 0x07, 0xFF, 0x57, // Character 59 (;)
0xFF, 0x03, 0xFC, 0x05, 0xF0, 0x17, 0xC0, 0x5F, 0xF0, 0x3F, 0xFC, 0x0F, 0xFF, 0x03, 0xFF, 0x55, // Character 60 (<)
0xFF, 0xFF, 0x00, 0x0F, 0x00, 0x07, 0xD5, 0x57, 0x00, 0x0F, 0x00, 0x07, 0xD5, 0x57, 0xFF, 0xFF, // Character 61 (=)
0xC0, 0xFF, 0xF0, 0x3F, 0xFC, 0x0F, 0xFF, 0x03, 0xFC, 0x05, 0xF0, 0x17, 0xC0, 0x5F, 0xF5, 0x7F, // Character 62 (>)
0x00, 0x03, 0x05, 0x41, 0xD7, 0xC1, 0xF0, 0x01, 0xF0, 0x15, 0xFD, 0x5F, 0xF0, 0x3F, 0xFD, 0x5F, // Character 63 (?)
0x00, 0x03, 0x00, 0x01, 0x05, 0x41, 0x04, 0x01, 0x05, 0x55, 0x00, 0x03, 0x00, 0x01, 0xD5, 0x55, // Character 64 (@)
0x00, 0x03, 0x05, 0x41, 0x07, 0xC1, 0x00, 0x01, 0x05, 0x41, 0x07, 0xC1, 0x07, 0xC1, 0xD7, 0xF5, // Character 65 (A)
0x00, 0x03, 0x05, 0x41, 0x07, 0xC1, 0x00, 0x05, 0x05, 0x43, 0x07, 0xC1, 0x00, 0x01, 0xD5, 0x55, // Character 66 (B)
0x00, 0x03, 0x00, 0x01, 0x05, 0x55, 0x07, 0xFF, 0x07, 0xFF, 0x00, 0x03, 0x00, 0x01, 0xD5, 0x55, // Character 67 (C)
0x00, 0x0F, 0x00, 0x03, 0x05, 0x41, 0x07, 0xC1, 0x07, 0xC1, 0x00, 0x01, 0x00, 0x05, 0xD5, 0x57, // Character 68 (D)
0x00, 0x03, 0x00, 0x01, 0x05, 0x55, 0x00, 0x03, 0x05, 0x55, 0x00, 0x03, 0x00, 0x01, 0xD5, 0x55, // Character 69 (E)
0x00, 0x03, 0x00, 0x01, 0x05, 0x55, 0x00, 0x03, 0x05, 0x55, 0x07, 0xFF, 0x07, 0xFF, 0xD7, 0xFF, // Character 70 (F)
0x00, 0x03, 0x00, 0x01, 0x05, 0x55, 0x07, 0x03, 0x07, 0xC1, 0x00, 0x01, 0x00, 0x01, 0xD5, 0x55, // Character 71 (G)
0x0F, 0xC3, 0x07, 0xC1, 0x00, 0x01, 0x00, 0x01, 0x05, 0x41, 0x07, 0xC1, 0x07, 0xC1, 0xD7, 0xF5, // Character 72 (H)
0x00, 0x03, 0x00, 0x01, 0xD0, 0x15, 0xF0, 0x1F, 0xF0, 0x1F, 0x00, 0x03, 0x00, 0x01, 0xD5, 0x55, // Character 73 (I)
0x00, 0x03, 0x00, 0x01, 0xD4, 0x05, 0xFC, 0x07, 0x0C, 0x07, 0x00, 0x07, 0xC0, 0x1F, 0xD5, 0x5F, // Character 74 (J)
0x03, 0xC3, 0x03, 0x01, 0x00, 0x01, 0x00, 0x05, 0x00, 0x03, 0x01, 0x01, 0x01, 0xC1, 0xD5, 0xF5, // Character 75 (K)
0x03, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x01, 0xFF, 0x00, 0x03, 0x00, 0x03, 0x00, 0x01, 0xD5, 0x55, // Character 76 (L)
0x0F, 0xC3, 0x03, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x04, 0x41, 0x07, 0x41, 0xD7, 0xF5, // Character 77 (M)
0x0F, 0xC3, 0x03, 0xC1, 0x00, 0xC1, 0x00, 0x01, 0x04, 0x01, 0x07, 0x01, 0x07, 0xC1, 0xD7, 0xF5, // Character 78 (N)
0xC0, 0x0F, 0x00, 0x03, 0x05, 0x41, 0x07, 0xC1, 0x07, 0xC1, 0x00, 0x01, 0xC0, 0x05, 0xF5, 0x57, // Character 79 (O)
0x00, 0x03, 0x00, 0x01, 0x05, 0x41, 0x00, 0x01, 0x00, 0x01, 0x05, 0x55, 0x07, 0xFF, 0xD7, 0xFF, // Character 80 (P)
0xC0, 0x0F, 0x00, 0x03, 0x05, 0x41, 0x07, 0xC1, 0x07, 0x05, 0x00, 0x01, 0xC0, 0x41, 0xF5, 0x57, // Character 81 (Q)
0x00, 0x03, 0x00, 0x01, 0x05, 0x41, 0x00, 0x01, 0x00, 0x01, 0x04, 0x05, 0x07, 0x01, 0xD7, 0xD5, // Character 82 (R)
0x00, 0x03, 0x00, 0x01, 0x05, 0x55, 0x00, 0x01, 0x55, 0x41, 0x00, 0x01, 0x00, 0x01, 0xD5, 0x55, // Character 83 (S)
0x00, 0x03, 0x00, 0x01, 0xD0, 0x15, 0xF0, 0x1F, 0xF0, 0x1F, 0xF0, 0x1F, 0xF0, 0x1F, 0xFD, 0x5F, // Character 84 (T)
0x0F, 0xC3, 0x07, 0xC1, 0x07, 0xC1, 0x07, 0xC1, 0x07, 0xC1, 0x00, 0x01, 0x00, 0x01, 0xD5, 0x55, // Character 85 (U)
0x03, 0x03, 0x03, 0x01, 0x03, 0x01, 0x00, 0x01, 0x00, 0x01, 0xC0, 0x05, 0xF0, 0x17, 0xFD, 0x5F, // Character 86 (V)
0x0C, 0xC3, 0x04, 0x41, 0x04, 0x41, 0x00, 0x01, 0x00, 0x01, 0x00, 0x05, 0xC1, 0x07, 0xF5, 0x57, // Character 87 (W)
0x0F, 0xC3, 0x03, 0x01, 0x00, 0x01, 0xC0, 0x05, 0x00, 0x03, 0x01, 0x01, 0x05, 0xC1, 0xD7, 0xF5, // Character 88 (X)
0x0F, 0xC3, 0x07, 0xC1, 0x00, 0x01, 0x00, 0x01, 0xD5, 0x41, 0x00, 0x01, 0x00, 0x05, 0xD5, 0x57, // Character 89 (Y)
0x00, 0x03, 0x00, 0x01, 0xD0, 0x01, 0xC0, 0x05, 0x00, 0x1F, 0x00, 0x03, 0x00, 0x01, 0xD5, 0x55, // Character 90 (Z)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 91 ([)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 92 (\)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 93 (])
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 94 (^)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 95 (_)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 96 (`)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 97 (a)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 98 (b)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 99 (c)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 100 (d)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 101 (e)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 102 (f)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 103 (g)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 104 (h)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 105 (i)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 106 (j)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 107 (k)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 108 (l)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 109 (m)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 110 (n)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 111 (o)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 112 (p)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 113 (q)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 114 (r)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 115 (s)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 116 (t)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 117 (u)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 118 (v)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 119 (w)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 120 (x)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 121 (y)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 122 (z)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 123 ({)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 124 (|)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 125 (})
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 126 (~)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 127
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 128
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 129
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 130
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 131
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 132
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 133
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 134
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 135
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 136
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 137
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 138
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 139
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 140
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 141
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 142
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 143
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 144
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 145
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 146
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 147
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 148
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 149
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 150
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 151
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 152
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 153
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 154
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 155
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 156
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 157
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 158
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 159
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 160 ( )
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 161 (¡)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 162 (¢)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 163 (£)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 164 (¤)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 165 (¥)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 166 (¦)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 167 (§)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 168 (¨)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 169 (©)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 170 (ª)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 171 («)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 172 (¬)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 173 (­)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 174 (®)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 175 (¯)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 176 (°)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 177 (±)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 178 (²)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 179 (³)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 180 (´)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 181 (µ)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 182 (¶)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 183 (·)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 184 (¸)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 185 (¹)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 186 (º)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 187 (»)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 188 (¼)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 189 (½)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 190 (¾)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 191 (¿)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 192 (À)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 193 (Á)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 194 (Â)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 195 (Ã)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 196 (Ä)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 197 (Å)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 198 (Æ)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 199 (Ç)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 200 (È)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 201 (É)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 202 (Ê)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 203 (Ë)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 204 (Ì)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 205 (Í)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 206 (Î)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 207 (Ï)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 208 (Ð)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 209 (Ñ)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 210 (Ò)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 211 (Ó)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 212 (Ô)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 213 (Õ)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 214 (Ö)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 215 (×)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 216 (Ø)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 217 (Ù)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 218 (Ú)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 219 (Û)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 220 (Ü)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 221 (Ý)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 222 (Þ)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 223 (ß)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 224 (à)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 225 (á)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 226 (â)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 227 (ã)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 228 (ä)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 229 (å)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 230 (æ)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 231 (ç)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 232 (è)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 233 (é)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 234 (ê)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 235 (ë)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 236 (ì)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 237 (í)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 238 (î)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 239 (ï)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 240 (ð)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 241 (ñ)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 242 (ò)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 243 (ó)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 244 (ô)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 245 (õ)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 246 (ö)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 247 (÷)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 248 (ø)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 249 (ù)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 250 (ú)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 251 (û)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 252 (ü)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 253 (ý)
0xBD, 0x7E, 0xC1, 0x43, 0xC6, 0x93, 0x5A, 0xA5, 0x5A, 0xA5, 0xC6, 0x93, 0xC1, 0x43, 0xBD, 0x7E, // Character 254 (þ)
0x3F, 0xFC, 0xFF, 0xFF, 0xFB, 0xEF, 0xFF, 0xFF, 0xFE, 0xBF, 0xDF, 0xF7, 0xF5, 0x5F, 0x3F, 0xFC, // Character 255 (ÿ)
};
PROGMEM prog_uchar RobotRicCharacterSet::PaletteData[] = {
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x80, // Character 0
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 1
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 2
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 3
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 4
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 5
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 6
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 7
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 8
0xE0, 0x03, 0x00, 0x7C, 0xE0, 0x7F, 0x00, 0x80, // Character 9
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 10
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 11
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 12
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 13
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 14
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 15
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 16
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x1F, 0x63, // Character 17
0x10, 0x00, 0x1F, 0x00, 0x1F, 0x42, 0x00, 0x80, // Character 18
0x08, 0x41, 0x10, 0x7E, 0x18, 0x02, 0x00, 0x80, // Character 19
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 20
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 21
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 22
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 23
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 24
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 25
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 26
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 27
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 28
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 29
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 30
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 31
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 32 ( )
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 33 (!)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 34 (")
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 35 (#)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 36 ($)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 37 (%)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 38 (&)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 39 (')
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 40 (()
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 41 ())
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 42 (*)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 43 (+)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 44 (,)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 45 (-)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 46 (.)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 47 (/)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 48 (0)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 49 (1)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 50 (2)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 51 (3)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 52 (4)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 53 (5)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 54 (6)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 55 (7)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 56 (8)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 57 (9)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 58 (:)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 59 (;)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 60 (<)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 61 (=)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 62 (>)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 63 (?)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 64 (@)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 65 (A)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 66 (B)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 67 (C)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 68 (D)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 69 (E)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 70 (F)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 71 (G)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 72 (H)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 73 (I)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 74 (J)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 75 (K)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 76 (L)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 77 (M)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 78 (N)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 79 (O)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 80 (P)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 81 (Q)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 82 (R)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 83 (S)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 84 (T)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 85 (U)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 86 (V)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 87 (W)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 88 (X)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 89 (Y)
0xFF, 0x7F, 0x10, 0x42, 0x1F, 0x7C, 0x00, 0x80, // Character 90 (Z)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 91 ([)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 92 (\)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 93 (])
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 94 (^)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 95 (_)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 96 (`)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 97 (a)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 98 (b)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 99 (c)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 100 (d)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 101 (e)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 102 (f)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 103 (g)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 104 (h)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 105 (i)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 106 (j)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 107 (k)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 108 (l)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 109 (m)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 110 (n)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 111 (o)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 112 (p)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 113 (q)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 114 (r)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 115 (s)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 116 (t)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 117 (u)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 118 (v)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 119 (w)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 120 (x)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 121 (y)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 122 (z)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 123 ({)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 124 (|)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 125 (})
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 126 (~)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 127
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 128
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 129
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 130
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 131
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 132
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 133
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 134
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 135
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 136
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 137
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 138
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 139
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 140
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 141
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 142
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 143
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 144
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 145
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 146
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 147
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 148
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 149
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 150
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 151
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 152
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 153
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 154
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 155
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 156
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 157
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 158
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 159
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 160 ( )
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 161 (¡)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 162 (¢)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 163 (£)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 164 (¤)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 165 (¥)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 166 (¦)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 167 (§)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 168 (¨)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 169 (©)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 170 (ª)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 171 («)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 172 (¬)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 173 (­)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 174 (®)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 175 (¯)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 176 (°)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 177 (±)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 178 (²)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 179 (³)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 180 (´)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 181 (µ)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 182 (¶)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 183 (·)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 184 (¸)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 185 (¹)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 186 (º)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 187 (»)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 188 (¼)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 189 (½)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 190 (¾)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 191 (¿)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 192 (À)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 193 (Á)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 194 (Â)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 195 (Ã)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 196 (Ä)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 197 (Å)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 198 (Æ)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 199 (Ç)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 200 (È)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 201 (É)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 202 (Ê)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 203 (Ë)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 204 (Ì)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 205 (Í)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 206 (Î)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 207 (Ï)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 208 (Ð)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 209 (Ñ)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 210 (Ò)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 211 (Ó)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 212 (Ô)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 213 (Õ)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 214 (Ö)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 215 (×)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 216 (Ø)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 217 (Ù)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 218 (Ú)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 219 (Û)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 220 (Ü)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 221 (Ý)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 222 (Þ)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 223 (ß)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 224 (à)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 225 (á)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 226 (â)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 227 (ã)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 228 (ä)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 229 (å)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 230 (æ)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 231 (ç)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 232 (è)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 233 (é)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 234 (ê)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 235 (ë)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 236 (ì)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 237 (í)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 238 (î)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 239 (ï)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 240 (ð)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 241 (ñ)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 242 (ò)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 243 (ó)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 244 (ô)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 245 (õ)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 246 (ö)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 247 (÷)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 248 (ø)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 249 (ù)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 250 (ú)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 251 (û)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 252 (ü)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 253 (ý)
0xFF, 0x7F, 0xE0, 0x03, 0x1F, 0x7C, 0x00, 0x00, // Character 254 (þ)
0x00, 0x00, 0xE0, 0x03, 0xE0, 0x7F, 0x00, 0x7C, // Character 255 (ÿ)
};
