/*
 * SOURCE FILE : MutantObject.cpp
 *
 * Represents a mutated human.
 *
 */

#include "MutantObject.h"
#include "SpriteImageId.h"

// Speed at which grunt moves.
Int16 MutantObject::mutantSpeed = FromPixel( 1 );

/**********************/
/* START OFF A MUTANT */
/**********************/
// Pass pointer to human mutant will replace in human.
// Pass pointer to object it will chase in player.
void MutantObject::Start( HumanObject *human, GameObject *player ) {
    // Copy coordinate of human to mutant.
    Xco = human->Xco;
    Yco = human->Yco;
    // Use the same sprite number as the human.
    SpriteNumber = human->SpriteNumber;
    // Use an appropriate sprite image.
    SpriteImage = ( human->GetHumanType() == HumanObject::Woman ) ? MutantWomanImage : MutantManImage;
    // Make it chase the player.
    SetChaseObject( player );
    // Set initial direction as either up or down.
    direction = ( Yco > chaseObject->Yco ) ? UpDir4 : DownDir4;
}

/************************/
/* MOVE THE GAME OBJECT */
/************************/
void MutantObject::ProtectedMove( void ) {
    switch( direction ) {
    case UpDir4 :
        Yco -= mutantSpeed;
        if( Yco <= chaseObject->Yco ) {
            direction = ( Xco > chaseObject->Xco ) ? LeftDir4 : RightDir4;
        }
        break;
    case RightDir4 :
        Xco += mutantSpeed;
        if( Xco >= chaseObject->Xco ) {
            direction = ( Yco > chaseObject->Yco ) ? UpDir4 : DownDir4;
        }
        break;
    case DownDir4 :
        Yco += mutantSpeed;
        if( Yco >= chaseObject->Yco ) {
            direction = ( Xco > chaseObject->Xco ) ? LeftDir4 : RightDir4;
        }
        break;
    case LeftDir4 :
        Xco -= mutantSpeed;
        if( Xco <= chaseObject->Xco ) {
            direction = ( Yco > chaseObject->Yco ) ? UpDir4 : DownDir4;
        }
        break;
    }
}

