/*
 * SOURCE FILE : Level0.cpp
 *
 * Definition of class Level0.
 *
 */

#include "Level0.h"
#include "CharBlocks.h"

/***************/
/* CONSTRUCTOR */
/***************/
Level0::Level0() {
    // Level zero (attract mode) is NOT dynamically allocated.
    IsDynamicallyAllocated = false;
}

/**************/
/* DESTRUCTOR */
/**************/
Level0::~Level0() {
}

/**************/
/* PLAY LEVEL */
/**************/
// Returns code indicating how level ended.
Level::LevelExitCode Level0::Play( void ) {
  return PlayLoop();
}

static const char startText[] = "OPERATE EITHER JOYSTICK TO START GAME";

/********************/
/* DRAW HIGH SCORES */
/********************/
void Level0::DrawHighScores( void ) {
  // Draw high score table.
  GDExtra::WriteProgString( gd, 16, 11, StringData::HighScoresString );
  PlayerName name;
  UInt32 score;
  UInt8 y = 13;
  for( UInt8 i = 0; i < highScores->GetCapacity(); ++i ) {
    highScores->Get( i, &name, &score );
    gd->putstr( 18, y, name.Name );
    GDExtra::WriteBCDNumber( gd, 22, y, score, 8 );
    y += 2;
  }
}

/*************/
/* PLAY LOOP */
/*************/
// Returns code indicating how level ended.
// This method should be called from the Play method after the
// level data has been initialised and the return value returned
// by the Play method.
Level::LevelExitCode Level0::PlayLoop( void ) {
  // Must have a Gameduino defined.
  if( gd != (Gameduino*)NULL ) {
      // Set screen background to black.
      gd->wr( Gameduino::BG_COLOR, Gameduino::RGB( 0, 0, 0 ) );
      GDExtra::ClearScreen( gd, TransparentChar );
      GDExtra::HideAllSprites( gd );
      // SoundManager::Instance.SilenceAll();
      // Draw border around screen.
      CharFrame::Draw( gd, 0, 0, VISIBLE_CHAR_WIDTH, VISIBLE_CHAR_HEIGHT );
      // Draw big block of characters that read "ROBOTRIC".
      GDExtra::WriteProgCharBlock( gd, 2, 2, CharBlocks::RobotRicText );
      // Write message telling user how to start game.
      GDExtra::WriteProgString( gd, 2, VISIBLE_CHAR_HEIGHT - 3, startText );
      // Validate high scores in EEPROM which will re-write the entire
      // table with default data if it finds nonsense in the EEPROM.
      // Then check if EEPROM now makes sense. If it does then display
      // the high score table. If it does not then chances are there
      // is no EEPROM connected so don't bother with high scores.
      if( highScores != (HighScoreTable*)NULL ) {
           highScores->ValidateEEPROM();
           if( highScores->EEPROMValid() ) {
               DrawHighScores();
           }
      }
      // Must have a player with non-NULL controls.
      PanelControls *controls;
      if(
        ( player != (PlayerObject*)NULL ) &&
        ( ( controls = player->GetControls() ) != (PanelControls*)NULL )
      ) {
        // Wait until all panel controls are released.
        UInt16 inputs;
        do {
          controls->Read();
          inputs = controls->GetInputs();
        } while( inputs != 0 );
        // Wait until a panel control is activated.
        do {
          controls->Read();
          inputs = controls->GetInputs();
        } while( inputs == 0 );
      }
    }
    return Completed;
}
