/*
 * SOURCE FILE : Level.h
 *
 * Definition of class Level.
 * Base class for all levels.
 *
 */

#ifndef LevelDefined

  #define LevelDefined

  #include "Types.h"
  #include "Gameduino.h"               // Gameduino library
  #include "GDExtra.h"                 // a few more Gameduino related functions
  #include "GDConst.h"                 // a few more Gameduino constants
  #include "CharCodes.h"               // character codes
  #include "CharBlocks.h"
  #include "StringData.h"
  #include "HighScoreTable.h"
  #include "CharFrame.h"
  #include "PanelControls.h"
  #include "PlayerObject.h"
  #include "ArenaConst.h"
  #include "SpriteImageId.h"
  #include "GameObject.h"
  #include "HumanObject.h"
  #include "GruntObject.h"
  #include "CrusherObject.h"
  #include "BrainObject.h"
  #include "MutantObject.h"
  #include "BlueMeanyObject.h"
  #include "SoundManager.h"
  #include "Sounds.h"
  
  class Level {

  public :

    // Number of this level.
    UInt8 LevelNumber;
    
    // True if level was dynamically allocated.
    bool IsDynamicallyAllocated;
    
    /***************/
    /* CONSTRUCTOR */
    /***************/
    Level();

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~Level();

    /************************/
    /* SET HIGH SCORE TABLE */
    /************************/
    // Pass pointer to EEPROM in e.
    void SetHighScores( HighScoreTable *hst ) {
        highScores = hst;
    }

    /*************************************************/
    /* SET GAMEDUINO ON WHICH GRAPHICS WILL BE DRAWN */
    /*************************************************/
    // Pass pointer to a Gameduino.
    void SetGameduino( Gameduino *g ) {
        gd = g;
    }
                
    /***************************************/
    /* SET PLAYER WHO IS PLAYING THE LEVEL */
    /***************************************/
    // Pass pointer to player in p.
    void SetPlayer( PlayerObject *p ) {
      player = p;
    }
    
    // Enumeration of reasons why level ended.
    enum LevelExitCode {
      Completed,       // level was completed
      GameOver,        // player has no more lives
    };
    
    /**************/
    /* PLAY LEVEL */
    /**************/
    // Returns code indicating how level ended.
    virtual LevelExitCode Play( void ) = 0;
    
  protected :
  
    // Pointer to high score table.
    HighScoreTable *highScores;
        
    // Gameduino on which level is played.
    Gameduino *gd;
    
    // Player playing the level.
    PlayerObject *player;
    
    /*************/
    /* PLAY LOOP */
    /*************/
    // Returns code indicating how level ended.
    // This method should be called from the Play method after the
    // level data has been initialised and the return value returned
    // by the Play method.
    virtual LevelExitCode PlayLoop( void ) = 0;

  };

#endif

/* END of Level.h */

