/*
 * SOURCE FILE : HighScoreEntry.h
 *
 * Definition of class HighScoreEntry.
 * Routine to allow player to enter their name using joysticks.
 *
 */

#ifndef HighScoreEntryDefined

  #define HighScoreEntryDefined

  #include "Types.h"
  #include "PanelControls.h"   // for reading panel controls.
  #include "PlayerName.h"
  #include "Gameduino.h"
  #include "FieldGrid.h"       // grid around which cursor moves
  
  class HighScoreEntry {

  public :

    /***************/
    /* CONSTRUCTOR */
    /***************/
    HighScoreEntry();

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~HighScoreEntry();

    /*********************/
    /* GET A PLAYER NAME */
    /*********************/
    // Pass pointer to place to store name in name.
    // Pass pointer to controls to read in controls.
    // Pass pointer to Gameduino to display on in gd.
    void GetName( PlayerName *name, PanelControls *controls, Gameduino *gd );

private :

    // Index of character being modified in the name.
    UInt8 charIndex;
    
    // Grid row and column number for cursor.
    UInt8 cursorRow, cursorColumn;
    
    // Grid around which cursor moves.
    FieldGrid grid;

    // Some text.
    static const char textDelete[];
    static const char textEnter[];
        
    /*******************/
    /* INITIALISE GRID */
    /*******************/
    void InitialiseGrid( void );
    
    /***************************************/
    /* ADD A CELL CONTAINING TEXT TO A ROW */
    /***************************************/
    // Pass character coordinates in x and y. These will be updated.
    // Pass row to which cells should be added in row.
    // Pass text which is to be contained in cell in text.
    void AddTextCell( UInt8 &x, UInt8 &y, FieldRow *row, const char *text );

    /************************************************************************/
    /* PERFORM A SPECIAL FUNCTION TRIGGERED FROM A CELL ON LAST ROW OF GRID */
    /************************************************************************/
    // Pass pointer to Gameduino to draw on in gd.
    // Pass function number in funcNum (this is the cursor column number).
    // Pass player name in name.
    // Pass reference to done flag in done.
    void SpecialFunction( Gameduino *gd, UInt8 funcNum, PlayerName *name, bool &done );

    /*********************/
    /* WAIT FOR CONTROLS */
    /*********************/
    // Pass pointer to Gameduino to display on in gd.
    // Pass pointer to controls to read in controls.
    // Pass true in waitActivate to wait for a control to be used.
    // Pass false to wait for release.
    void WaitControls( Gameduino *gd, PanelControls *controls, bool waitActivate );

    /*******************/
    /* DRAW THE SCREEN */
    /*******************/
    // Pass pointer to Gameduino to display on in gd.
    // Pass player name in name.
    void DrawScreen( Gameduino *gd, PlayerName *name );

    /***************************/
    /* DRAW THE CHARACTER GRID */
    /***************************/
    // Pass pointer to Gameduino to draw on in gd.
    void DrawGrid( Gameduino *gd );

    /********************************/
    /* DRAW THE NAME AND THE CURSOR */
    /********************************/
    // Pass pointer to Gameduino to display on in gd.
    // Pass player name in name.
    void DrawName( Gameduino *gd, PlayerName *name );
    
    /********************/
    /* UPDATE ANIMATION */
    /********************/
    // Pass pointer to Gameduino to display on in gd.
    void Animate( Gameduino *gd );

    /*******************/
    /* WIPE THE CURSOR */
    /*******************/
    // Pass pointer to Gameduino to display on in gd.
    // Pass cell to draw in cell.
    void WipeCursor( Gameduino *gd, FieldCell *cell );

    /*******************/
    /* DRAW THE CURSOR */
    /*******************/
    // Pass pointer to Gameduino to display on in gd.
    // Pass cell to draw in cell.
    void DrawCursor( Gameduino *gd, FieldCell *cell );
    
    /**************************/
    /* VALIDATE CURSOR COLUMN */
    /**************************/
    // If cursor column is beyond end of row then forces it back.
    void ValidateCursorColumn( void );
    
  };

#endif

/* END of HighScoreEntry.h */

