/*
 * SOURCE FILE : FieldGrid.h
 *
 * Definition of class FieldGrid.
 * This is a grid of rectangles used for fields on a form or whatever.
 *
 */

#ifndef FieldGridDefined

  #define FieldGridDefined

  #include <stdlib.h>           // for NULL
  #include "Types.h"
  #include "FieldRow.h"
  
  class FieldGrid {

  public :

    /***************/
    /* CONSTRUCTOR */
    /***************/
    // Pass number of rows in grid in rc.
    FieldGrid( UInt8 rc );

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~FieldGrid();

    /*************/
    /* GET A ROW */
    /*************/
    // Pass row number in rowNum.
    // Returns pointer to row or NULL if no such row.
    FieldRow *GetRow( UInt8 rowNum );

    /*****************/
    /* GET ROW COUNT */
    /*****************/
    // Returns number of rows.
    UInt8 GetRowCount( void ) const {
        return rowCount;
    }

    /*****************************************/
    /* GET CELL AT PARTICULAR ROW AND COLUMN */
    /*****************************************/
    // Pass row number in rowNum.
    // Pass column number in columnNum.
    // Returns pointer to cell or NULL if cell does not exist.
    FieldCell *GetCellAt( UInt8 rowNum, UInt8 columnNum ) {
        FieldRow *row = GetRow( rowNum );
        if( row != (FieldRow*)NULL ) {
            return row->GetCellAt( columnNum );
        }
        else {
            return (FieldCell*)NULL;
        }
    }
    
  private :
  
    // Pointer to array of FieldRow objects, one for each row in the grid.
    FieldRow *rows;
    
    // Number of rows.
    UInt8 rowCount;
    
  };

#endif

/* END of FieldGrid.h */


