/*
 * SOURCE FILE : EnemyObject.cpp
 *
 * Base class for enemy objects.
 *
 */

#include "EnemyObject.h"

// Default object to chase.
PlayerObject EnemyObject::defaultChaseObject;

/*****************************************************/
/* CHECK IF ALL SURVIVING ENEMIES ARE INDESTRUCTABLE */
/*****************************************************/
// Pass pointer to array of pointers to EnemyObjects in enemies.
// Pass number of pointers in the array in enemyCount.
bool EnemyObject::AreAllIndestructable( const EnemyObject **enemies, UInt8 enemyCount ) {
  const EnemyObject *enemy;
  bool foundMortal = false;
  UInt8 i = 0;
    while( ! foundMortal && ( i < enemyCount ) ) {
    enemy = enemies[ i ];
    if( ( enemy != (EnemyObject*)NULL ) && ( enemy->HitPoints != Indestructable ) ) {
      foundMortal = true;
    }
        i++;
  }
  return ! foundMortal;
}
