/*
 * SOURCE FILE : EnemyFactory.cpp
 *
 * Definition of class EnemyFactory.
 *
 */

#include "EnemyFactory.h"

// Define this for debugging messages.
#undef CHATTY

#ifdef CHATTY
    #include "mbed.h"
    extern Serial pc;
#endif

// An instance of this class.
EnemyFactory EnemyFactory::Instance;

/***************/
/* CONSTRUCTOR */
/***************/
EnemyFactory::EnemyFactory() :
    enemyCount( 0UL )
{
}

/**************/
/* DESTRUCTOR */
/**************/
EnemyFactory::~EnemyFactory()
{
}

/*****************/
/* MAKE AN ENEMY */
/*****************/
// Pass enemy type in et.
// Returns a newly created object or NULL on failure.
EnemyObject* EnemyFactory::MakeEnemy( EnemyType et ) {
    EnemyObject *enemy;
    switch( et ) {
    
    case Grunt :
        enemy = new GruntObject();
        break;
        
    case BlueMeany :
        enemy = new BlueMeanyObject();
        break;
        
    case Crusher :
        enemy = new CrusherObject();
        break;
        
    case Brain :
        enemy = new BrainObject();
        break;

    case BrainBullet :
        enemy = new BrainBulletObject();
        break;
                
    case Mutant :
        enemy = new MutantObject();
        break;
        
    default :
        enemy = (EnemyObject*)NULL;
        break;
        
    }
    
    if( enemy != (EnemyObject*)NULL ) {
        enemyCount++;
        #ifdef CHATTY
            pc.printf( "Enemy type %d created. %lu enemies exist.\r\n", (int)enemy->GetEnemyType(), enemyCount );
        #endif
    }
    
    return enemy;
}

/*******************/
/* DELETE AN ENEMY */
/*******************/
// Pass pointer to enemy to delete.
// ONLY USE THIS ON OBJECTS CREATED USING MakeEnemy method.
void EnemyFactory::DeleteEnemy( EnemyObject *enemy ) {
    enemyCount--;
    #ifdef CHATTY
        pc.printf( "Enemy type %d deleted. %lu enemies exist.\r\n", (int)enemy->GetEnemyType(), enemyCount );
    #endif
    delete enemy;
}
