/*
 * SOURCE FILE : CharFrame.cpp
 *
 * For drawing rectangular frames using characters.
 *
 */

#include "CharFrame.h"
#include "GDConst.h"      // a few Gameduino constants
#include "CharCodes.h"    // character set codes

/****************/
/* DRAW A FRAME */
/****************/
// Pass Gameduino to draw on in gd.
// Pass x coordinate of top left in x.
// Pass y coordinate of top left in y.
// Pass width in w.
// Pass height in h.
void CharFrame::Draw( Gameduino *gd, UInt8 x, UInt8 y, UInt8 w, UInt8 h ) {
  // Calculate address for top left.
  unsigned int rowStart = Gameduino::RAM_PIC + y * SCREEN_CHAR_WIDTH + x;
  unsigned int address = rowStart;
  UInt8 count;
  // Draw top left corner.
  gd->wr( address++, TopLeft );
  // Draw top edge.
  if( w > 2 ) {
    for( count = w - 2; count > 0; --count ) {
      gd->wr( address++, Top );
    }
  }
  // Draw top right corner.
  gd->wr( address, TopRight );
  // Draw left and right edges.
  rowStart += SCREEN_CHAR_WIDTH;
  if( h > 2 ) {
    for( count = h - 2; count > 0; --count ) {
      gd->wr( rowStart, Left );
      gd->wr( rowStart + w - 1, Right );
      rowStart += SCREEN_CHAR_WIDTH;
    }
  }
  // Draw bottom edge.
  address = rowStart;
  // Draw bottom left corner.
  gd->wr( address++, BottomLeft );
  // Draw bottom edge.
  if( w > 2 ) {
    for( count = w - 2; count > 0; --count ) {
      gd->wr( address++, Bottom );
    }
  }
  // Draw bottom right corner.
  gd->wr( address, BottomRight );
}

/****************/
/* WIPE A FRAME */
/****************/
// Pass Gameduino to draw on in gd.
// Pass x coordinate of top left in x.
// Pass y coordinate of top left in y.
// Pass width in w.
// Pass height in h.
void CharFrame::Wipe( Gameduino *gd, UInt8 x, UInt8 y, UInt8 w, UInt8 h ) {
  // Calculate address for top left.
  unsigned int rowStart = Gameduino::RAM_PIC + y * SCREEN_CHAR_WIDTH + x;
  unsigned int address;
  UInt8 count;
  // Wipe top edge.
  address = rowStart;
  for( count = w; count > 0; --count ) {
    gd->wr( address++, TransparentChar );
  }
  // Wipe left and right edges.
  address = rowStart + SCREEN_CHAR_WIDTH;
  if( h > 2 ) {
      for( count = h - 2; count > 0; --count ) {
          gd->wr( address, TransparentChar );
          gd->wr( address + w - 1, TransparentChar );
      }
  }
  // Wipe bottom edge.
  address = rowStart + SCREEN_CHAR_WIDTH * ( h - 1 );
  for( count = w; count > 0; --count ) {
    gd->wr( address++, TransparentChar );
  }
}
