/*
 * SOURCE FILE : BulletVelocityCalculator.h
 *
 * Definition of class BulletVelocityCalculator.
 * Used to calculate the horizontal and vertical velocities necessary for a bullet to
 * hit a target,
 *
 */

#ifndef BulletVelocityCalculatorDefined

  #define BulletVelocityCalculatorDefined

    #include "Types.h"
    
  class BulletVelocityCalculator {

  public :

        /*******************************/
        /* CALCULATE BULLET VELOCITIES */
        /*******************************/
        // Pass distances to target in dx and dy.
        // Pass velocity at which bullet moves in v.
        // Horizontal and vertical velocities returned in variables pointed to by hv and vv.
        static void CalculateVelocities( Int16 dx, Int16 dy, Int16 v, Int16 *hv, Int16 *vv );
        
  };

#endif

/* END of BulletVelocityCalculator.h */

