/*
 * SOURCE FILE : BrainBulletObject.h
 *
 * Definition of class BrainBulletObject.
 * This is the enemy object used as a bullet fired by BrainObject enemies.
 *
 */

#ifndef BrainBulletObjectDefined

  #define BrainBulletObjectDefined

    #include "EnemyObject.h"
    
  class BrainBulletObject : public EnemyObject {

  public :

        // Horizontal and vertical velocities at which bullet is moving.
        // NOT pixel velocities.
        Int16 HVelocity, VVelocity;
        
    /***************/
    /* CONSTRUCTOR */
    /***************/
    BrainBulletObject();

        /*****************************/
        /* GET TYPE OF ENEMY THIS IS */
        /*****************************/
        // Returns enemy type.
        virtual EnemyType GetEnemyType( void ) {
            return BrainBullet;
        }

    /*******************************************************/
    /* GET NUMBER OF POINTS AWARDED FOR KILLING THIS ENEMY */
    /*******************************************************/
    // Returns number of points (in BCD).
    virtual UInt8 GetPoints( void ) {
            return 0x10;
        }

    /************************/
    /* DRAW THE GAME OBJECT */
    /************************/
    // Note if Visible is false this should not draw anything
    // and/or hide the visible object.
    virtual void Draw( Gameduino *gd );

  protected :
  
    /************************/
    /* MOVE THE GAME OBJECT */
    /************************/
    virtual void ProtectedMove( void );
        
    };

#endif

/* END of BrainBulletObject.h */
