/*
 * SOURCE FILE : BCDNumber.cpp
 *
 * A 4 byte unsigned BCD integer.
 *
 */

#include "BCDNumber.h"

/***********************/
/* ADD TWO BCD NUMBERS */
/***********************/
// Pass first number in A.
// Pass second number in B.
// Pass pointer to result in result.
// Pass carry flag in carry.
// Remember numbers are BCD coded so 0x99999999 means 9 million,
// 9 hundred and 99 thousand, 9 hundred and 99.
// Returns carry flag. If this is set then overflow occurred.
bool BCDNumber::Add( UInt32 numA, UInt32 numB, UInt32 *result, bool carry ) {
  const UInt8 *ptrA = (const UInt8*)&numA;
  const UInt8 *ptrB = (const UInt8*)&numB;
  UInt8 *ptrR = (UInt8*)result;
  UInt8 sum, digits;
  for( UInt8 b = 0; b < ByteCount; ++b ) {
    digits = 0;
    // Add together lower 4 bits.
    sum = ( *ptrA & 0xF ) + ( *ptrB & 0xF );
    // If carry flag set then add one.
    if( carry ) {
      sum++;
    }
    // If result is >= 10 then set carry and subtract 10 from sum.
    carry = ( sum >= 10 );
    if( carry ) {
      sum -= 10;
    }
    // Write lower 4 bits.
    digits |= sum;
    // Add together upper 4 bits and carry.
    sum = ( ( *ptrA & 0xF0 ) >> 4 ) + ( ( *ptrB & 0xF0 ) >> 4 );
    // If carry flag set then add one.
    if( carry ) {
      sum++;
    }
    // If result is >= 10 then set carry and subtract 10 from sum.
    carry = ( sum >= 10 );
    if( carry ) {
      sum -= 10;
    }
    // Write upper 4 bits.
    digits |= ( sum << 4 );
    // Store digits in result and skip to next byte.
    *ptrR++ = digits;
    ptrA++;
    ptrB++;
  }
  return carry;
}

