/*
 * SOURCE FILE : Animations.h
 *
 * Animations consisting of arrays of sprite image numbers in program memory.
 *
 */
 
#ifndef AnimationsIncluded

  #define AnimationsIncluded

  #include "Types.h"
  
  class Animations {
    
  public :
  
    static const UInt8 WomanAnimation[];
    static const UInt8 ManAnimation[];
    
    enum {
      HumanAnimationCount = 2,    // number of animations there are for humans
    };
    
    // Array containing addresses of all the human animations.
    static const UInt8 *HumanAnimations[ HumanAnimationCount ];
    
        static const UInt8 CrusherAnimation[];
        
  };
  
#endif

// END of Animations.h

