/*
 * SOURCE FILE : Sounds.cpp
 *
 * Various sounds in program memory.
 *
 */

#include "Sounds.h"
#include "Gameduino.h"
#include "Notes.h"

const UInt8 Sounds::FireGun[] = {
  Gameduino::WhiteNoise,    // waveform
  Notes::NoteD1, 15, 10,    // frequency, amplitude, duration
  Notes::NoteC1, 12, 5,
  Notes::NoteB1, 9, 5,
  Notes::NoteA1, 6, 5,
  Notes::NoteEndMarker
};

const UInt8 Sounds::Explosion[] = {
  Gameduino::WhiteNoise,    // waveform
  Notes::NoteD0, 15, 20,    // frequency, amplitude, duration
  Notes::NoteC0, 12, 5,
  Notes::NoteB0, 9, 5,
  Notes::NoteA0, 6, 5,
  Notes::NoteEndMarker
};

const UInt8 Sounds::RescueHuman[] = {
  Gameduino::SineWave,      // waveform
  Notes::NoteG4, 15, 5,     // frequency, amplitude, duration
  Notes::NoteCS5, 15, 5,
  Notes::NoteG5, 15, 5,
  Notes::NoteEndMarker
};

const UInt8 Sounds::HumanDies[] = {
    Gameduino::SineWave,    // waveform
  Notes::NoteC5, 15, 5,     // frequency, amplitude, duration
    Notes::NoteAS5, 15, 5,
  Notes::NoteC5, 15, 5,
    Notes::NoteAS5, 15, 5,
  Notes::NoteC5, 15, 5,
    Notes::NoteAS5, 15, 5,
    Notes::NoteG4, 15, 5,
    Notes::NoteDS4, 15, 5,
  Notes::NoteC4, 15, 5,
    Notes::NoteAS4, 15, 5,
    Notes::NoteG3, 15, 5,
  Notes::NoteEndMarker
};

const UInt8 Sounds::PlayerDead[] = {
  Gameduino::SineWave,      // waveform
  Notes::NoteA4, 20, 39,    // frequency, amplitude, duration
  Notes::NoteSilent, 0, 1,
  Notes::NoteA4, 20, 29,
  Notes::NoteSilent, 0, 1,
  Notes::NoteA4, 20, 9,
  Notes::NoteSilent, 0, 1,
  Notes::NoteA4, 20, 39,
  Notes::NoteSilent, 0, 1,
  Notes::NoteC4, 20, 29,
  Notes::NoteSilent, 0, 1,
  Notes::NoteB4, 20, 9,
  Notes::NoteSilent, 0, 1,
  Notes::NoteB4, 20, 29,
  Notes::NoteSilent, 0, 1,
  Notes::NoteA4, 20, 9,
  Notes::NoteSilent, 0, 1,
  Notes::NoteA4, 20, 29,
  Notes::NoteSilent, 0, 1,
  Notes::NoteGS3, 20, 9,
  Notes::NoteSilent, 0, 1,
  Notes::NoteA4, 20, 79,
  Notes::NoteEndMarker
};

const UInt8 Sounds::StartLevel[] = {
  Gameduino::SineWave,      // waveform
  
  Notes::NoteG0, 20, 2,     // frequency, amplitude, duration
  Notes::NoteB1, 20, 2,
  Notes::NoteD1, 20, 2,
  Notes::NoteC1, 20, 2,
  Notes::NoteE1, 20, 2,
  Notes::NoteG1, 20, 2,
  Notes::NoteFS1, 20, 2,
  Notes::NoteA2, 20, 2,
  Notes::NoteC2, 20, 2,
  
  Notes::NoteG1, 20, 2,     // frequency, amplitude, duration
  Notes::NoteB2, 20, 2,
  Notes::NoteD2, 20, 2,
  Notes::NoteC2, 20, 2,
  Notes::NoteE2, 20, 2,
  Notes::NoteG2, 20, 2,
  Notes::NoteFS2, 20, 2,
  Notes::NoteA3, 20, 2,
  Notes::NoteC3, 20, 2,
  
  Notes::NoteG2, 20, 2,     // frequency, amplitude, duration
  Notes::NoteB3, 20, 2,
  Notes::NoteD3, 20, 2,
  Notes::NoteC3, 20, 2,
  Notes::NoteE3, 20, 2,
  Notes::NoteG3, 20, 2,
  Notes::NoteFS3, 20, 2,
  Notes::NoteA4, 20, 2,
  Notes::NoteC4, 20, 2,
  
  Notes::NoteG3, 20, 2,     // frequency, amplitude, duration
  Notes::NoteB4, 20, 2,
  Notes::NoteD4, 20, 2,
  Notes::NoteC4, 20, 2,
  Notes::NoteE4, 20, 2,
  Notes::NoteG4, 20, 2,
  Notes::NoteFS4, 20, 2,
  Notes::NoteA5, 20, 2,
  Notes::NoteC5, 20, 2,
  
  Notes::NoteG4, 20, 2,     // frequency, amplitude, duration
  Notes::NoteB5, 20, 2,
  Notes::NoteD5, 20, 2,
  Notes::NoteC5, 20, 2,
  Notes::NoteE5, 20, 2,
  Notes::NoteG5, 20, 2,
  Notes::NoteFS5, 20, 2,
  Notes::NoteA6, 20, 2,
  Notes::NoteC6, 20, 2,
  
  Notes::NoteG5, 20, 2,     // frequency, amplitude, duration
  Notes::NoteB6, 20, 2,
  Notes::NoteD6, 20, 2,
  Notes::NoteG6, 20, 20,
  Notes::NoteSilent, 0, 10,
  Notes::NoteG6, 20, 20,
  Notes::NoteSilent, 0, 10,
  Notes::NoteG6, 20, 20,

  Notes::NoteEndMarker
};

const UInt8 Sounds::ExtraLife[] = {
  Gameduino::SineWave,      // waveform
  Notes::NoteG5, 15, 5,     // frequency, amplitude, duration
  Notes::NoteCS6, 15, 5,
  Notes::NoteG6, 15, 5,
  Notes::NoteG5, 15, 5,
  Notes::NoteCS6, 15, 5,
  Notes::NoteG6, 15, 5,
  Notes::NoteG5, 15, 5,
  Notes::NoteCS6, 15, 5,
  Notes::NoteG6, 15, 5,
  Notes::NoteEndMarker
};
