/*
 * SOURCE FILE : PlayerObject.h
 *
 * Represents the player objects.
 *
 */

#ifndef PlayerObjectIncluded
  
  #define PlayerObjectIncluded

  #include "Gameduino.h"
  #include "GameObject.h"
  #include "BulletManager.h"
  #include "PanelControls.h"
  #include "BulletVelocities.h"
  #include "SpriteImageId.h"
  #include "BCDNumber.h"
  
  class PlayerObject : public GameObject {
    
  public :

    // Lives remaining.
    UInt8 Lives;
    
    // Score as a BCD number.
    UInt32 Score;
    
    /***************/
    /* CONSTRUCTOR */
    /***************/
    PlayerObject();

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~PlayerObject();

    /**************************************/
    /* SET CONTROLS FOR THE PLAYER TO USE */
    /**************************************/
    // Pass controls to use in pc.
    void SetControls( PanelControls *pc ) {
      controls = pc;
    }

    /*****************************************/
    /* GET CONTROLS BEING USED BY THE PLAYER */
    /*****************************************/
    PanelControls *GetControls( void ) const {
      return controls;
    }
    
    /******************************/
    /* READ THE PLAYER'S CONTROLS */
    /******************************/
    void ReadControls( void ) {
      if( controls != (PanelControls*)NULL ) {
        controls->Read();
      }
    }
    
    /************************/
    /* GET GAME OBJECT TYPE */
    /************************/
    // Returns type of game object.
    virtual GameObjectTypes GetType( void ) {
      return PlayerObjectType;
    }

    /************************/
    /* MOVE THE GAME OBJECT */
    /************************/
    virtual void ProtectedMove( void );

    /************************/
    /* DRAW THE GAME OBJECT */
    /************************/
    // Pass pointer to Gameduino to draw on in gd.
    // This is only called after it has been established that the
    // game object is visible.
    virtual void Draw( Gameduino *gd );

    /*********************************/
    /* KILL A SINGLE PLAYER'S BULLET */
    /*********************************/
    // Pass pointer to Gameduino to draw on in gd.
    // Pass index of bullet in b.
    void KillBullet( Gameduino *gd, UInt8 b ) {
      playerBullets.KillBullet( gd, b );
    }
    
    /*****************************/
    /* KILL ALL PLAYER'S BULLETS */
    /*****************************/
    // Pass pointer to Gameduino to draw on in gd.
    void KillAllBullets( Gameduino *gd ) {
      playerBullets.KillAllBullets( gd );
    }

    /*********************************************************/
    /* GET ARRAY CONTAINING POINTERS TO ALL PLAYER'S BULLETS */
    /*********************************************************/
    // Returns pointer to array of GameObject pointers.
    // The array has BulletManager::MaxBullets pointers in it.
    GameObject **GetBullets( void ) {
      return playerBullets.GetBullets();
    }
    
    /*************************/
    /* ADD TO PLAYER'S SCORE */
    /*************************/
    // Pass number of points to add in points (THIS IS BCD CODED!).
    void AddToScore( UInt16 points );
    
  private :

    // Pointer to object used to read joysticks and buttons.
    PanelControls *controls;
    
    // Manages player's bullets.
    BulletManager playerBullets;
    
    // Countdown until next bullet available.
    UInt8 bulletCountdown;
    
    // Bullet velocity information.
    static BulletVelocities bulletVelocities;

    // Player movement velocities.
    static BulletVelocities playerVelocities;

  };
    
#endif

/* END of PlayerObject.h */

