/*
 * SOURCE FILE : PlayerName.h
 *
 * Definition of class PlayerName.
 * Contains the name that appears in a high score table for example.
 *
 */

#ifndef PlayerNameDefined

  #define PlayerNameDefined

  #include "Types.h"
  
  class PlayerName {

  public :

    enum {
      Length = 3,      // Number of characters used for name.
      MinChar = ' ',   // First valid character in a name.
      MaxChar = 'Z',   // Last valid character in a name.
    };
  
    // Characters that make up the name, plus a zero char at the end.
    char Name[ Length + 1 ];
    
    /***************/
    /* CONSTRUCTOR */
    /***************/
    PlayerName();

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~PlayerName();

    /************************************************************/
    /* COPY ONE NAME TO ANOTHER WITHOUT CREATING A NEW INSTANCE */
    /************************************************************/
    // Pass pointer to name to copy to in dest.
    void CopyTo( PlayerName *dest ) const;
    
  };

  
#endif

/* END of PlayerName.h */

