/*
 * SOURCE FILE : MathFuncs.h
 *
 * Definition of class MathFuncs.
 *
 */

#ifndef MathFuncsDefined

    #define MathFuncsDefined
    
    #include "Types.h"
    
    /** Various useful maths related functions. */
    class MathFuncs {
    
    public :

        /** Constrain a number to be between 2 values.
         *
         * @param x Number to constrain.
         * @param min Minimum value.
         * @param max Maximum value.
         * @returns A number between min and max.
         */
        static Int16 Constrain( Int16 x, Int16 min, Int16 max ) {
            if( x < min ) {
                return min;
            }
            else if( x > max ) {
                return max;
            }
            else {
                return x;
            }
        }
            
    };

#endif

/* END of MathFuncs.h */

