/*
 * SOURCE FILE : LevelData.h
 *
 * Definition of class LevelData.
 *
 */

#ifndef LevelDataDefined

  #define LevelDataDefined

  #include "GameObject.h"
  #include "EnemyObject.h"
  #include "HumanObject.h"
  #include "MutantObject.h"
  
  class LevelData {

  public :

    enum {
      MaxEnemies = 64,           // Maximum number of enemies you can have in a level
      MaxHumans = 24,            // maximum number of humans you can have in a level
    };
    
    // Array containing pointers to all the enemies in a level.
    // A null pointer indicates an unused or dead enemy.
    GameObject *Enemies[ MaxEnemies ];
    
    // Array containing pointers to all the humans in a level.
    // A null pointer indicates an unused or rescued human.
    GameObject *Humans[ MaxHumans ];
    
    /***************/
    /* CONSTRUCTOR */
    /***************/
    LevelData();

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~LevelData();

  };

#endif

/* END of LevelData.h */

