/*
 * SOURCE FILE : LevelCollection.h
 *
 * Definition of class LevelCollection.
 *
 */

#ifndef LevelCollectionDefined

  #define LevelCollectionDefined
  
  #include "Types.h"
  #include "Level.h"

  class LevelCollection {

  public :

    enum {
      AttractLevel = 0,        // just ticking over encouraging player to start
      FirstNormalLevel = 1,    // first real level excluding attract mode
    };
    
    /***************/
    /* CONSTRUCTOR */
    /***************/
    LevelCollection();

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~LevelCollection();

    /************************/
    /* GET NUMBER OF LEVELS */
    /************************/
    UInt8 GetLevelCount( void ) const;

    /***************/
    /* GET A LEVEL */
    /***************/
    // Pass level number in levelNumber.
    // Returns pointer to level or NULL if no such level.
    // Note that the level MAY be dynamically allocated and you must
    // call FreeLevel when you have finished with the level to release
    // memory used.
    Level *GetLevel( UInt8 levelNumber );
    
    /*******************************/
    /* FREE MEMORY USED BY A LEVEL */
    /*******************************/
    // Pass pointer to a level.
    // Frees memory used by level.
    void FreeLevel( Level *level );
    
  };

#endif

/* END of LevelCollection.h */

