/*
 * SOURCE FILE : GameRobotRic.h
 *
 * The RobotRic game class.
 *
 */

#ifndef GameRobotRicIncluded
  
  #define GameRobotRicIncluded

  #include "Gameduino.h"          // Gameduino stuff
  #include "Game.h"               // base class for all games
  #include "PanelControls.h"      // for joysticks and buttons
  #include "PlayerObject.h"
  #include "HighScoreTable.h"     // for high score table stored in external EEPROM

  class GameRobotRic : public Game {
    
  public :

    /*****************/
    /* PLAY THE GAME */
    /*****************/
    // This NEVER exits.
    void Play( void );

  private :
  
    // The one and only player.
    PlayerObject player;
    
    // Controls used by player.
    PanelControls controls;
    
    /**************************/
    /* CHECK FOR A HIGH SCORE */
    /**************************/
    // Pass pointer to a Gameduino to display on in gd.
    // Pass pointer to high score table in highScores.
    // Pass score that was achieved in score.
    void CheckForHighScore( Gameduino *gd, HighScoreTable *highScores, UInt32 score );

  };
    
#endif

/* END of GameRobotRic.h */

