/*
 * SOURCE FILE : FieldRow.h
 *
 * Definition of class FieldRow.
 *
 */

#ifndef FieldRowDefined

  #define FieldRowDefined

  #include "FieldCell.h"
  
  class FieldRow {

  public :

    /***************/
    /* CONSTRUCTOR */
    /***************/
    FieldRow();

    /**************/
    /* DESTRUCTOR */
    /**************/
    virtual ~FieldRow();

    /*************************/
    /* ADD A CELL TO THE ROW */
    /*************************/
    // Pass cell to add in cell.
    // The cell being added must have been dynamically allocated!
    void AddCell( FieldCell *cell );

    /*************************/
    /* GET FIRST CELL IN ROW */
    /*************************/
    // Returns pointer to first cell or NULL if no cells in row.
    FieldCell *GetFirstCell( void ) {
        FieldCell *result = root.GetNext();
        if( result == (FieldCell*)NULL ) {
            nextCell = (FieldCell*)NULL;
        }
        else {
            nextCell = result->GetNext();
        }
        return result;
    }
    
    /************************/
    /* GET NEXT CELL IN ROW */
    /************************/
    // Returns pointer to NEXT cell or NULL if no MORE cells in row.
    FieldCell *GetNextCell( void ) {
        FieldCell *result = nextCell;
        if( result != (FieldCell*)NULL ) {
            nextCell = result->GetNext();
        }
        return result;
    }
    
    /**********************************************/
    /* GET CELL AT PARTICULAR POSITION IN THE ROW */
    /**********************************************/
    // Pass index of cell in pos.
    // Returns pointer to cell or NULL if no cell at given index.
    FieldCell *GetCellAt( UInt8 pos ) {
        FieldCell *result = GetFirstCell();
        while( ( pos > 0 ) && ( result != (FieldCell*)NULL ) ) {
            result = GetNextCell();
            pos--;
        }
        return result;
    }

    /********************************/
    /* GET NUMBER OF COLUMNS IN ROW */
    /********************************/
    // Returns number of columns in row.
    UInt8 GetColumnCount( void ) {
        UInt8 count = 0;
        FieldCell *cell = GetFirstCell();
        while( cell != (FieldCell*)NULL ) {
            count++;
            cell = GetNextCell();
        }
        return count;
    }
        
  private :
  
    // The root cell of the row.
    // Does not contain any useful data and never gets deleted.
    FieldCell root;
    
    // Pointer used when scanning through row cells.
    FieldCell *nextCell;
            
  };

#endif

/* END of FieldRow.h */


