/*
 * SOURCE FILE : FieldRow.cpp
 *
 * Definition of class FieldRow.
 *
 */

#include "FieldRow.h"

/***************/
/* CONSTRUCTOR */
/***************/
FieldRow::FieldRow() :
    nextCell( (FieldCell*)NULL )
{
}

/**************/
/* DESTRUCTOR */
/**************/
FieldRow::~FieldRow()
{
    // Free all the cells in the row starting at the one after the root cell.
    FieldCell *ptr = root.GetNext();
    FieldCell *next;
    while( ptr != (FieldCell*)NULL ) {
        next = ptr->GetNext();
        delete ptr;
        ptr = next;
    }
}

/*************************/
/* ADD A CELL TO THE ROW */
/*************************/
// Pass cell to add in cell.
// The cell being added must have been dynamically allocated!
void FieldRow::AddCell( FieldCell *cell ) {
    // Start at the root cell.
    FieldCell *ptr = &root;
    // Follow chain until you find a cell who has no next cell.
    FieldCell *next;
    while( ( next = ptr->GetNext() ) != (FieldCell*)NULL ) {
        ptr = next;
    }
    // Make last cell point to new cell.
    ptr->SetNext( cell );
    // Make new cell point to nothing since it is the last cell.
    cell->SetNext( (FieldCell*)NULL );
}
