/*
 * SOURCE FILE : BulletVelocityCalculator.cpp
 *
 * Definition of class BulletVelocityCalculator.
 *
 */

#include <stdlib.h>         // for abs
#include "BulletVelocityCalculator.h"

// A few constants.
#define COS11_25 0.980785
#define SIN11_25 0.195090
#define COS33_75 0.831470
#define SIN33_75 0.555570
#define COS56_25 0.555570
#define SIN56_25 0.831470
#define COS78_75 0.195090
#define SIN78_75 0.980785

/*******************************/
/* CALCULATE BULLET VELOCITIES */
/*******************************/
// Pass distances to target in dx and dy.
// Pass velocity at which bullet moves in v.
// Horizontal and vertical velocities returned in variables pointed to by hv and vv.
void BulletVelocityCalculator::CalculateVelocities( Int16 dx, Int16 dy, Int16 v, Int16 *hv, Int16 *vv ) {
    Int16 ax = abs( dx );
    Int16 ay = abs( dy );
    if( ax < 8 ) {
        *hv = 0;
        *vv = v;
    }
    else if( ay < 8 ) {
        *hv = v;
        *vv = 0;
    }
    else {
        float ratio = (float)ay / (float)ax;
        if( ratio < 0.5f ) {
            *hv = v * COS11_25;
            *vv = v * SIN11_25;
        }
        else if( ratio < 1.0f ) {
            *hv = v * COS33_75;
            *vv = v * SIN33_75;
        }
        else if( ratio < 2.0f ) {
            *hv = v * COS56_25;
            *vv = v * SIN56_25;
        }
        else {
            *hv = v * COS78_75;
            *vv = v * SIN78_75;
        }
    }
    if( dx < 0 ) {
        *hv = -(*hv);
    }
    if( dy < 0 ) {
        *vv = -(*vv);
    }
}
